#!/bin/bash

# HWPDocument 클래스 테스트 스크립트
cd "$(dirname "$(dirname "$0")")" || exit 1

python3 -c "
from utils import HWPDocument

# 문서 객체 생성
doc = HWPDocument()

# 메인 제목 추가
doc.add_heading('한글 문서 종합 테스트')

# 소개 문단 추가
doc.add_paragraph('이 문서는 HWPDocument 클래스의 모든 기능을 테스트하기 위한 문서입니다.')
doc.add_paragraph('아래는 각 기능의 테스트 결과입니다.')

# 1. 여러 줄 텍스트 및 특수문자 테스트
doc.add_heading('1. 여러 줄 텍스트 및 특수문자 테스트')
multiline_text = '''제 1장 테스트 문서
o 첫 번째 목록 항목
- 두 번째 수준 목록
o 두 번째 목록 항목
<그림>
이것은 일반 문단입니다.
<표>
[특수] 대괄호로 시작하는 특수 항목

빈 줄이 포함된 여러 줄 텍스트입니다.
마지막 줄입니다.'''

for line in multiline_text.split('\\n'):
    if line.strip():  # 빈 줄 건너뛰기
        if line in ['<그림>', '<표>']:  # 특수 마커 건너뛰기
            continue
        if line.startswith('제'):  # 제목 스타일
            doc.add_heading(line)
        else:  # 일반 문단
            doc.add_paragraph(line)

# 2. 이미지 테스트
doc.add_page_break()
doc.add_heading('2. 이미지 테스트')
doc.add_image('assets/airun_logo.png')
doc.add_paragraph('위 이미지는 AIRun 로고입니다.')

# 3. 표 테스트
doc.add_page_break()
doc.add_heading('3. 표 테스트')
table_data = [
    ['기능', '설명', '비고'],
    ['제목 스타일', '문서의 제목과 소제목을 설정할 수 있습니다.', '새로 추가된 기능'],
    ['텍스트 입력', '문단 단위로 텍스트를 입력할 수 있습니다.', '기본 기능'],
    ['이미지 삽입', '다양한 이미지를 문서에 포함할 수 있습니다.', '지원 포맷: PNG, JPG'],
    ['표 생성', '데이터를 표 형식으로 표현할 수 있습니다.', '자동 생성']
]
doc.add_table(table_data)

# 4. 페이지 나누기 테스트
doc.add_page_break()
doc.add_heading('4. 페이지 나누기 테스트')
doc.add_paragraph('이 내용은 새로운 페이지에서 시작됩니다.')
doc.add_paragraph('페이지 넘김이 정상적으로 동작하는지 확인합니다.')

# 5. 두 번째 이미지 테스트
doc.add_page_break()
doc.add_heading('5. 두 번째 이미지 테스트')
doc.add_image('assets/airun_logo.png')
doc.add_paragraph('두 번째 페이지의 로고 이미지입니다.')

# 6. 긴 텍스트 테스트
doc.add_page_break()
doc.add_heading('6. 긴 텍스트 테스트')
doc.add_paragraph('아래는 80자가 넘는 긴 텍스트의 처리 테스트입니다.')

long_text = '''오픈소스 소프트웨어는 현대 소프트웨어 개발에서 매우 중요한 역할을 하고 있습니다. 많은 기업들이 오픈소스를 활용하여 개발 시간을 단축하고 비용을 절감하며, 혁신적인 솔루션을 만들어내고 있습니다.

특히 인공지능과 머신러닝 분야에서는 TensorFlow, PyTorch와 같은 오픈소스 프레임워크들이 연구와 개발을 가속화하는데 큰 기여를 하고 있습니다. 이러한 도구들은 전 세계의 개발자들이 협력하여 만들어낸 결과물이며, 지속적으로 발전하고 있습니다.

오픈소스 커뮤니티는 코드 공유뿐만 아니라 지식과 경험의 공유도 활발하게 이루어지고 있어, 소프트웨어 개발 생태계의 건강한 성장을 이끌어내고 있습니다.'''

doc.add_text_content(long_text)


# 7. 글머리 기호와 특수 문자 테스트
doc.add_page_break()
doc.add_heading('7. 글머리 기호와 특수 문자 테스트')
doc.add_paragraph('아래는 다양한 글머리 기호와 특수 문자의 처리 테스트입니다.')

bullet_text = '''1. 첫 번째 항목: 숫자로 시작하는 목록입니다.
1.1. 첫 번째 하위 항목입니다.
1.2. 두 번째 하위 항목입니다.

• 글머리 기호로 시작하는 항목입니다.
- 하이픈으로 시작하는 항목입니다.
* 별표로 시작하는 항목입니다.

A. 알파벳으로 시작하는 항목입니다.
B. 두 번째 알파벳 항목입니다.
   B-1. 들여쓰기가 있는 하위 항목입니다.
   B-2. 또 다른 들여쓰기 항목입니다.

① 원문자로 시작하는 항목입니다.
② 두 번째 원문자 항목입니다.

[참고] 대괄호로 시작하는 특수 항목입니다.
<메모> 꺾쇠로 시작하는 특수 항목입니다.
※ 참고 표시로 시작하는 항목입니다.
☞ 화살표로 시작하는 항목입니다.

중간에 *강조* 표시가 있는 문장입니다.
_밑줄_이 있는 문장입니다.
"큰따옴표"와 '작은따옴표'가 있는 문장입니다.
(괄호)와 [대괄호]가 있는 문장입니다.'''

# 글머리 기호 텍스트를 문장 단위로 분리하여 처리
for line in bullet_text.split('\n'):
    line = line.strip()
    if not line:  # 빈 줄은 간격을 위해 공백 문단 추가
        doc.add_paragraph(' ')
    else:
        doc.add_paragraph(line)

# 문서 저장
doc.save('test.hwpx')
print('[INFO] Test document has been created: test.hwpx')
" 