# AI.RUN 워크스페이스

AI.RUN의 다양한 기능들을 웹과 모바일에서 일관된 사용자 경험으로 제공하는 통합 인터페이스입니다.

## 프로젝트 구조

```
workspaces/
├── web/                      # 웹 클라이언트 (Next.js)
│   ├── src/                  # 소스 코드
│   │   ├── app/              # Next.js App Router
│   │   ├── components/       # 컴포넌트
│   │   └── styles/           # 스타일
│   └── public/               # 정적 파일
│
├── mobile/                   # 모바일 클라이언트 (React Native) - 추후 개발
│   ├── screens/              # 화면 컴포넌트
│   ├── navigation/           # 네비게이션
│   ├── widgets/              # 모바일용 위젯
│   └── styles/               # 모바일 전용 스타일
│
├── shared/                   # 웹/모바일 공유 코드
    ├── api/                  # API 클라이언트 및 서비스
    ├── components/           # 공통 컴포넌트
    ├── hooks/                # 공통 훅
    ├── store/                # 상태 관리
    ├── types/                # 타입 정의
    └── utils/                # 유틸리티 함수

```

## 기능 개요

AI.RUN 워크스페이스는 다음과 같은 주요 기능을 제공합니다:

1. **대화하기 (Chat)**: AI 모델과의 대화, RAG/웹 검색 통합
2. **코드 작업 (Code)**: 코드 생성, 분석, 편집
3. **문서 작업 (Document)**: 문서 작성, 분석, 변환
4. **자동화 (Automation)**: MCP 도구 실행 및 관리
5. **설정 (Settings)**: AI 프로바이더, API 키, 환경 설정
6. **모니터링 (Monitoring)**: 사용량, 실행 상태, 로그 확인

## 기술 스택

### 공통
- TypeScript
- API 클라이언트
- 상태관리: Zustand

### 웹
- Next.js
- React
- Tailwind CSS

### 서버
- Express (기존 API 서버 활용)

## 시작하기

### 웹 클라이언트 실행

```bash
# 웹 클라이언트 디렉토리로 이동
cd workspaces/web

# 종속성 설치
npm install

# 개발 모드 실행
npm run dev
```

### 환경 설정

`.env.local` 파일을 생성하여 환경 변수를 설정할 수 있습니다:

```bash
# API 서버 URL
NEXT_PUBLIC_API_URL=http://localhost:5500/api/v1
```

## API 서비스

API 서비스는 API 서버와의 통신을 담당합니다. 다음과 같은 서비스가 제공됩니다:

- `chatService`: 대화 기능 API
- `codeService`: 코드 작업 API
- `documentService`: 문서 작업 API
- `automationService`: 자동화 기능 API
- `settingsService`: 설정 관리 API
- `monitoringService`: 모니터링 API

## 개발 전략

1. **단계적 개발**
   - 웹 버전 먼저 개발 및 안정화
   - 공통 로직을 shared로 점진적 이동
   - 모바일 버전 개발 (추후)

2. **코드 공유 전략**
   - 비즈니스 로직 최대한 공유
   - UI는 플랫폼별 최적화
   - 타입과 상태 관리 통일

3. **UI/UX 가이드라인**
   - 일관된 디자인 시스템
   - 플랫폼별 최적화
   - 접근성 고려

## 기여하기

프로젝트에 기여하기 전에 다음 사항을 확인해 주세요:

1. 코드 컨벤션을 준수해 주세요.
2. 변경 사항에 대한 테스트를 추가해 주세요.
3. Pull Request를 생성하기 전에 코드를 리뷰해 주세요.

## 라이선스

이 프로젝트는 [LICENSE](LICENSE) 파일에 명시된 라이선스에 따라 배포됩니다. 