import React from 'react';

interface AlertProps {
  variant?: 'default' | 'destructive';
  className?: string;
  children: React.ReactNode;
}

export const Alert: React.FC<AlertProps> = ({ 
  variant = 'default', 
  className = '', 
  children 
}) => {
  return (
    <div 
      className={`p-4 rounded-md ${
        variant === 'destructive' 
          ? 'bg-red-100 dark:bg-red-900 text-red-800 dark:text-red-100' 
          : 'bg-blue-100 dark:bg-blue-900 text-blue-800 dark:text-blue-100'
      } ${className}`}
    >
      {children}
    </div>
  );
};

export const AlertTitle: React.FC<{ children: React.ReactNode }> = ({ children }) => {
  return <h5 className="font-medium mb-1">{children}</h5>;
};

export const AlertDescription: React.FC<{ children: React.ReactNode }> = ({ children }) => {
  return <div className="text-sm">{children}</div>;
}; 