// 평가 데이터(문제) 타입
export interface EvaluationItem {
  id: string;
  question: string;
  choices?: string[]; // 객관식일 경우
  answer: string;
}

// 모델 정보 타입
export interface ModelInfo {
  id: string;
  name: string;
  description?: string;
}

// 모델별 평가 결과 타입
export interface EvaluationResult {
  modelId: string;
  itemId: string;
  modelAnswer: string;
  correct: boolean;
  score?: number; // 정성적 평가 점수(예: 1~10)
}

// 리더보드용 집계 타입
export interface LeaderboardRow {
  modelId: string;
  modelName: string;
  accuracy: number;
  f1?: number;
  bleu?: number;
  rouge?: number;
  hallucination?: number;
  [key: string]: string | number | undefined;
} 