import { visit } from 'unist-util-visit';

export default function remarkBoxToHeading() {
  return (tree) => {
    // 표 블록 감지 및 변환
    let tableBuffer = [];
    let tableStartIdx = null;
    visit(tree, 'paragraph', (node, index, parent) => {
      const text = node.children && node.children[0] && node.children[0].type === 'text' ? node.children[0].value : '';
      // 표 줄인지 확인 (|로 시작하고 |가 2개 이상)
      const isTableLine = typeof text === 'string' && text.trim().startsWith('|') && (text.match(/\|/g) || []).length >= 2;
      if (isTableLine) {
        if (tableBuffer.length === 0) tableStartIdx = index;
        tableBuffer.push(text);
        // 마지막 노드이거나 다음 노드가 표가 아니면 변환
        const isLast = index === parent.children.length - 1;
        const nextNode = parent.children[index + 1];
        const nextText = nextNode && nextNode.children && nextNode.children[0] && nextNode.children[0].type === 'text' ? nextNode.children[0].value : '';
        const nextIsTable = nextNode && typeof nextText === 'string' && nextText.trim().startsWith('|') && (nextText.match(/\|/g) || []).length >= 2;
        if (isLast || !nextIsTable) {
          // 표 블록을 code 노드로 변환
          const codeNode = {
            type: 'code',
            lang: 'markdown',
            value: tableBuffer.join('\n'),
          };
          parent.children.splice(tableStartIdx, tableBuffer.length, codeNode);
          tableBuffer = [];
          tableStartIdx = null;
          return [visit.SKIP, index];
        }
        return;
      }
      // 기존 □ 처리 로직
      for (let i = 0; i < node.children.length; i++) {
        const child = node.children[i];
        if (child.type === 'text' && child.value.trim().startsWith('□')) {
          // "□"로 시작하는 텍스트를 heading으로 변환
          const headingNode = {
            type: 'heading',
            depth: 3,
            children: [{ type: 'text', value: child.value.trim() }],
          };

          // 나머지 children을 paragraph로 만듦
          const restChildren = node.children.slice(i + 1);
          const nodesToInsert = [];
          // 빈 paragraph(공백 줄) 추가
          nodesToInsert.push({ type: 'paragraph', children: [{ type: 'text', value: '' }] });
          nodesToInsert.push(headingNode);
          if (restChildren.length > 0) {
            nodesToInsert.push({
              type: 'paragraph',
              children: restChildren,
            });
          }
          parent.children.splice(index, 1, ...nodesToInsert);
          return [visit.SKIP, index + nodesToInsert.length];
        }
      }
    });
  };
}
