import { UserExperienceManager } from './index.js';
import { Langfuse } from 'langfuse';
import dotenv from 'dotenv';

// 환경 변수 로드
dotenv.config();

async function testFeedbackSystem() {
    if (!process.env.LANGFUSE_PUBLIC_KEY || !process.env.LANGFUSE_SECRET_KEY || !process.env.LANGFUSE_BASE_URL) {
        throw new Error('Langfuse 환경 변수가 설정되지 않았습니다.');
    }

    const userExperience = new UserExperienceManager();

    try {
        // Langfuse 초기화 완료 대기
        await new Promise(resolve => setTimeout(resolve, 1000));

        // 세션 시작
        const sessionId = await userExperience.startSession('test-user');
        console.log('Session started:', sessionId);

        // 테스트 데이터
        const testData = {
            userMessage: "테스트 사용자 메시지입니다.",
            aiResponse: "테스트 AI 응답입니다.",
            rating: 5,
            sessionId: sessionId,
            messageId: `message-${Date.now()}`,
            timestamp: new Date().toISOString()
        };

        // 메시지 로깅 테스트 (trackMessage가 아닌 logMessage 사용)
        console.log('메시지 로깅 테스트 시작...');
        await userExperience.logMessage(testData.userMessage, 'user');
        console.log('사용자 메시지 로깅 완료');
        
        await userExperience.logMessage(testData.aiResponse, 'assistant');
        console.log('AI 응답 메시지 로깅 완료');

        // 피드백 제출 테스트
        console.log('피드백 제출 테스트 시작...');
        const feedbackResult = await userExperience.submitFeedback(testData);
        console.log('피드백 제출 결과:', feedbackResult);

        // 세션 종료
        await userExperience.endSession();
        console.log('세션 종료 완료');

    } catch (error) {
        console.error('테스트 중 오류 발생:', error);
    }
}

// 테스트 실행
console.log('테스트 시작...');
testFeedbackSystem()
    .then(() => console.log('테스트 완료'))
    .catch(error => console.error('테스트 실패:', error));