# Ayuda de AI.RUN

## 🌟 Introducción
AI.RUN es una poderosa herramienta de orquestación de agentes de IA que integra y coordina varios modelos de IA para ejecutar tareas del sistema real.

## 📱 Cómo Usar

### Chat de IA
Pantalla principal donde puedes chatear con la IA y solicitar tareas.
- **Uso Básico**
  - Ingresa preguntas o tareas en la ventana de chat
  - Selecciona el modelo de IA en la esquina superior derecha
  - Haz clic en el botón de enviar para iniciar el chat
- **Modo Chat/Ejecución**
  - Modo Chat: Intercambio libre de información con la IA
  - Modo Ejecución: Ejecución directa de comandos del sistema y operaciones de archivos
- **Configuración de Prompts**
  - Personaliza prompts en Configuración > Configuración de IA
  - Configura prompts personalizados según el propósito de la tarea
  - Optimiza prompts para diferentes tipos de tareas

### Configuración del Entorno
Gestiona la configuración general del sistema.

- **Configuración de Modelos de IA**
  - Selección de proveedores de IA (OpenAI, Anthropic, Ollama, Gemini, Groq)
  - Registro y gestión de claves API
  - Selección y configuración de modelos

- **Configuración de Chat**
  - Confirmación antes de ejecutar comandos
  - Configuración de ejecución automática
  - Configuración de tema (oscuro/claro)
  - Configuración de idioma (coreano, inglés, japonés, chino, español, francés)

- **Configuración de RAG**
  - Opciones de uso de RAG
  - Configuración de ruta de documentos
  - Inicialización de base de datos y procesamiento de documentos

- **Configuración SMTP**
  - Host del servidor de correo
  - Número de puerto
  - Cuenta de usuario
  - Configuración de conexión segura

- **Funciones Adicionales**
  - Uso de búsqueda web
  - Inicialización de sesión
  - Inicialización de configuración

### Configuración de IA
Interfaz para gestionar prompts para el chat con IA.

- **Edición de Prompts**
  - Ver contenido de prompts actuales
  - Modificar y guardar prompts directamente
  - Restablecer a valores predeterminados

- **Prompts RAG**
  - Prompts especiales para función RAG
  - Prompts optimizados para búsqueda y referencia de documentos
  - Configuración de generación de respuestas de base de conocimientos

- **Funciones Principales**
  - Guardado en tiempo real de prompts
  - Restaurar prompts predeterminados
  - Aplicar prompts RAG
  - Vista previa de prompts

### Gestión de Tareas
Interfaz para guardar y gestionar tareas comunes de IA.
- **Métodos de Registro de Tareas**
  1. Registro Directo
     - Crear nueva tarea usando el botón 'Nueva Tarea'
     - Escribir nombre y descripción de la tarea
     - Escribir contenido de instrucciones de IA previamente
  2. Registro desde Chat
     - Hacer clic en el botón 'Registrar Tarea' de una tarea ejecutada exitosamente
     - Agregar nombre y descripción de la tarea
     - Guardar automáticamente el contenido de la tarea ejecutada

- **Tareas en Caché**
  - Crear automáticamente tareas en caché al registrar tareas exitosas desde el chat
  - Ejecutar rápidamente código guardado sin llamadas a IA
  - Reducir costos de ejecución de tareas
  - Especialmente útil para tareas del sistema frecuentes

- **Gestión de Tareas**
  - Ver estado y ejecutar/detener en lista de tareas
  - Modificar y eliminar contenido de tareas
  - Ver historial de ejecución
  - Gestionar actualizaciones de tareas en caché

### Estadísticas de Uso
Interfaz para ver uso y costos de modelos de IA.
- **Resumen General**
  - Costo total y uso total de tokens
  - Costo y uso de tokens del mes actual
  - Análisis y comparación de tendencias

- **Análisis por Proveedor**
  - Costo y uso de tokens por proveedor de IA
  - Estadísticas de número de solicitudes
  - Gráficos de distribución de costos por proveedor

- **Análisis Detallado**
  - Tendencias de uso mensual
  - Distribución de uso por período
  - Comparación de uso de tokens por modelo
  - Análisis de eficiencia de costos por modelo

- **Análisis de Sesiones**
  - Distribución de uso por sesión
  - Contenido de prompts iniciales
  - Estadísticas de costo y tokens por sesión

- **Registros Detallados**
  - Tabla de registros detallados de llamadas a IA
  - Información de tiempo, proveedor, modelo, tokens, costo
  - Soporte de descarga en formato CSV

### Historial de Ejecución
Interfaz para ver todos los comandos ejecutados y resultados en el chat de IA.
- **Registros de Ejecución**
  - Muestra tiempo y estado de ejecución (éxito/fallo)
  - Contenido de consulta del usuario
  - Código ejecutado
  - Resultados de ejecución

## 🚀 Funciones Principales

### 1. Orquestación de Agentes de IA
- **Integración Multi-proveedor**
  - Utiliza varios modelos de IA como OpenAI, Anthropic, Ollama, Google, Groq
  - Selección flexible entre ejecución local (Ollama) y servicios en la nube
  - Soporte de failover automático en caso de fallo del proveedor
  - Selección de proveedor basada en optimización de costo/rendimiento

- **Optimización de Prompts**
  - Proporciona plantillas de prompts adaptadas a características de cada modelo
  - Monitoreo en tiempo real del uso de tokens
  - Compresión y optimización de contexto
  - Soporte de prompts multilingües

### 2. Procesamiento de Documentos y Gestión de Conocimiento
- **RAG (Generación Aumentada por Recuperación)**
  - Incrustaciones de alto rendimiento basadas en modelo Xenova/all-MiniLM-L6-v2
  - Gestión estable de datos vectoriales con combinación ChromaDB + SQLite
  - Búsqueda híbrida: combinación de búsqueda semántica + palabras clave
  - División dinámica de bloques de documentos y gestión de metadatos

- **Soporte de Múltiples Formatos de Documentos**
  - Procesamiento nativo de documentos HWP, PDF, MS Office
  - Extracción y procesamiento de tablas/imágenes
  - Extracción y etiquetado automático de metadatos
  - Procesamiento por lotes de documentos de gran volumen

### 3. Integración y Automatización del Sistema
- **Sistema de Gestión de Tareas**
  - Automatización y programación de tareas repetitivas
  - Seguimiento de resultados de ejecución de tareas
  - Monitoreo y notificaciones en tiempo real
  - Gestión y reutilización de historial de tareas

- **Integración del Sistema**
  - Acceso directo y operación del sistema de archivos
  - Ejecución y automatización de comandos del sistema
  - Control de programas locales
  - Configuración automática del entorno de desarrollo

### 4. Integración Web y Correo Electrónico
- **Búsqueda Web Integrada**
  - Integración de motores de búsqueda multilingües como Google, Naver, Daum
  - Búsqueda estable basada en Selenium
  - Análisis y extracción automática de resultados de búsqueda
  - Optimización de velocidad de respuesta usando sistema de caché

- **Funcionalidad de Correo Electrónico**
  - Soporte de plantillas HTML
  - Envío masivo de correos
  - Procesamiento de adjuntos
  - Respuesta y clasificación automática de correos

### 5. Herramientas de Desarrollo
- **Gestión de Código**
  - Análisis de código basado en AST
  - Generación y optimización de código
  - Soporte de múltiples entornos de ejecución (Node.js, Python)
  - Entorno de ejecución sandbox

- **Gestión de Paquetes**
  - Resolución automática de dependencias
  - Verificación de compatibilidad de versiones
  - Verificación de vulnerabilidades de seguridad
  - Gestión de entornos virtuales

## 💡 Ventajas Principales

### 1. Optimización de Costos
- **Sistema de Caché**
  - Caché de resultados de búsqueda RAG (TTL: 72 horas)
  - Caché de resultados de búsqueda web
  - Caché de resultados de incrustaciones
  - Caché de información agregada

- **Optimización de Uso de Recursos**
  - Monitoreo de uso de tokens
  - Selección automática de modelo basada en costo-beneficio
  - Optimización de procesamiento por lotes
  - Prevención de solicitudes duplicadas

### 2. Rendimiento y Estabilidad
- **Arquitectura de Alto Rendimiento**
  - Estructura híbrida Node.js y Python
  - Estabilidad a través de aislamiento de procesos
  - Procesamiento multi-hilo
  - Optimización de uso de memoria

- **Manejo y Recuperación de Errores**
  - Mecanismo de reintento automático
  - Sistema de recuperación de fallos
  - Registro detallado de errores
  - Respaldo y recuperación automática

### 3. Seguridad y Cumplimiento
- **Seguridad de Datos**
  - Prevención de fugas de datos mediante ejecución en entorno local
  - Detección y enmascaramiento automático de información sensible
  - Control de acceso y gestión de permisos
  - Cumplimiento de normas como ISMS-P, GDPR

- **Monitoreo y Auditoría**
  - Registro de ejecución de tareas
  - Monitoreo de uso de recursos
  - Informes de auditoría de seguridad
  - Sistema de alertas en tiempo real

## 📊 Métricas de Rendimiento
- Tiempo de respuesta de búsqueda RAG
  * Sin caché: 4~5 segundos
  * Con caché: 0.002-0.005 segundos
- Tiempo de respuesta de búsqueda web
  * Búsqueda inicial: 4~5 segundos
  * Con caché: 0.001 segundos
- Rendimiento de procesamiento de documentos
  * Volumen recomendado: 5,000-10,000 páginas
  * Volumen máximo: 20,000-30,000 páginas

## 📞 Soporte Técnico
- Correo electrónico: sales@invesume.com
- Sitio web: https://invesume.com
- Teléfono: 02-2039-3977 / 010-3838-8378 