# AI.RUN 帮助

## 🌟 简介
AI.RUN是一个强大的AI代理编排工具，可以集成和协调各种AI模型来执行实际的系统任务。

## 📱 使用方法

### AI对话
可以与AI对话并请求任务的主屏幕。
- **基本使用**
  - 在对话窗口输入问题或任务
  - 从右上角选择AI模型
  - 点击发送按钮开始对话
- **对话/执行模式**
  - 对话模式：与AI自由交换信息
  - 执行模式：执行系统命令、文件操作等直接任务
- **提示词设置**
  - 在设置 > AI设置中自定义提示词
  - 根据任务目的设置自定义提示词
  - 针对不同任务类型优化提示词

### 环境设置
管理系统整体设置。

- **AI模型设置**
  - 选择AI提供商 (OpenAI, Anthropic, Ollama, Gemini, Groq)
  - API密钥注册和管理
  - 模型选择和设置

- **对话设置**
  - 命令执行前确认
  - 自动执行设置
  - 主题设置 (深色/浅色)
  - 语言设置 (韩语、英语、日语、中文、西班牙语、法语)

- **RAG设置**
  - RAG功能使用选项
  - 文档路径设置
  - 数据库初始化和文档处理

- **SMTP设置**
  - 邮件服务器主机
  - 端口号
  - 用户账户
  - 安全连接设置

- **附加功能**
  - 网络搜索使用
  - 会话初始化
  - 设置初始化

### AI设置
管理与AI对话的提示词的界面。

- **提示词编辑**
  - 查看当前使用的提示词内容
  - 直接修改和保存提示词
  - 可重置为默认值

- **RAG提示词**
  - 应用RAG功能的特殊提示词
  - 针对文档搜索和引用优化的提示词
  - 知识库响应生成设置

- **主要功能**
  - 提示词实时保存
  - 恢复默认提示词
  - 应用RAG提示词
  - 提示词预览

### 任务管理
保存和管理常用AI任务的界面。
- **任务注册方法**
  1. 直接注册
     - 使用'新建任务'按钮创建新任务
     - 编写任务名称和说明
     - 预先编写AI指令内容
  2. 从对话注册
     - 点击成功执行任务的'注册任务'按钮
     - 添加任务名称和说明
     - 自动保存执行的任务内容

- **缓存任务**
  - 从对话注册成功执行的任务时自动创建缓存任务
  - 无需AI调用即可快速执行保存的代码
  - 降低任务执行成本
  - 特别适用于频繁使用的系统任务

- **任务管理**
  - 在任务列表中查看状态和执行/停止
  - 修改和删除任务内容
  - 查看执行历史
  - 管理缓存任务更新

### 使用统计
查看AI模型使用量和成本的界面。
- **整体摘要**
  - 总成本和总令牌使用量
  - 本月成本和令牌使用量
  - 趋势分析和比较

- **提供商分析**
  - AI提供商的成本和令牌使用量
  - 请求数量统计
  - 提供商成本分布图表

- **详细分析**
  - 月度使用量趋势
  - 时段使用量分布
  - 模型令牌使用量比较
  - 模型成本效率分析

- **会话分析**
  - 会话使用量分布
  - 初始提示词内容
  - 会话成本和令牌统计

- **详细记录**
  - AI调用详细记录表
  - 时间、提供商、模型、令牌、成本信息
  - CSV格式下载支持

### 执行历史
查看AI对话中执行的所有命令和结果的界面。
- **执行记录**
  - 显示执行时间和状态(成功/失败)
  - 用户查询内容
  - 执行的代码
  - 执行结果

## 🚀 主要功能

### 1. AI代理编排
- **多提供商集成**
  - 利用OpenAI、Anthropic、Ollama、Google、Groq等各种AI模型
  - 灵活选择本地执行(Ollama)和云服务
  - 提供商故障时自动故障转移支持
  - 基于成本/性能优化的提供商选择

- **提示词优化**
  - 提供针对各模型特性的提示词模板
  - 实时监控令牌使用量
  - 上下文压缩和优化
  - 多语言提示词支持

### 2. 文档处理和知识管理
- **RAG (检索增强生成)**
  - 基于Xenova/all-MiniLM-L6-v2模型的高性能嵌入
  - ChromaDB + SQLite组合的稳定向量数据管理
  - 混合搜索：语义+关键词组合搜索
  - 动态文档块分割和元数据管理

- **多种文档格式支持**
  - HWP、PDF、MS Office文档原始处理
  - 表格/图像提取和处理
  - 自动元数据提取和标记
  - 大容量文档批处理

### 3. 系统集成和自动化
- **任务管理系统**
  - 重复任务自动化和调度
  - 跟踪任务执行结果
  - 实时监控和通知
  - 任务历史管理和重用

- **系统集成**
  - 直接访问和操作文件系统
  - 系统命令执行和自动化
  - 本地程序控制
  - 自动开发环境配置

### 4. Web和电子邮件集成
- **集成Web搜索**
  - 集成Google、Naver、Daum等多语言搜索引擎
  - 基于Selenium的稳定搜索
  - 自动分析和提取搜索结果
  - 使用缓存系统优化响应速度

- **电子邮件功能**
  - HTML模板支持
  - 批量邮件发送
  - 附件处理
  - 自动邮件响应和分类

### 5. 开发者工具
- **代码管理**
  - 基于AST的代码分析
  - 代码生成和优化
  - 多运行时支持 (Node.js, Python)
  - 沙箱执行环境

- **包管理**
  - 自动解决依赖关系
  - 版本兼容性检查
  - 安全漏洞检查
  - 虚拟环境管理

## 💡 主要优势

### 1. 成本优化
- **缓存系统**
  - RAG搜索结果缓存 (TTL: 72小时)
  - Web搜索结果缓存
  - 嵌入结果缓存
  - 集合信息缓存

- **资源使用优化**
  - 令牌使用量监控
  - 成本效益模型自动选择
  - 批处理优化
  - 重复请求防止

### 2. 性能和稳定性
- **高性能架构**
  - Node.js和Python混合结构
  - 通过进程隔离实现稳定性
  - 多线程处理
  - 内存使用优化

- **错误处理和恢复**
  - 自动重试机制
  - 故障恢复系统
  - 详细错误日志
  - 自动备份和恢复

### 3. 安全和合规
- **数据安全**
  - 通过本地环境执行防止数据泄露
  - 自动检测和屏蔽敏感信息
  - 访问控制和权限管理
  - 符合ISMS-P、GDPR等规范

- **监控和审计**
  - 任务执行日志记录
  - 资源使用量监控
  - 安全审计报告
  - 实时警报系统

## 📊 性能指标
- RAG搜索响应时间
  * 缓存未命中: 4~5秒
  * 缓存命中: 0.002-0.005秒
- Web搜索响应时间
  * 初始搜索: 4~5秒
  * 缓存命中: 0.001秒
- 文档处理性能
  * 建议文档量: 5,000-10,000页
  * 最大处理量: 20,000-30,000页

## 📞 技术支持
- 电子邮件: sales@invesume.com
- 网站: https://invesume.com
- 电话: 02-2039-3977 / 010-3838-8378 