import TaskAnalyzer from './analyzers/TaskAnalyzer.js';
import TaskManager from './managers/TaskManager.js';

class TaskService {
    constructor() {
        this.taskAnalyzer = new TaskAnalyzer();
        this.taskManager = new TaskManager();
    }

    async handleTaskRequest(message) {
        try {
            // 작업 분석
            const steps = await this.taskAnalyzer.analyzeTask(message);
            
            // 작업 단계 추가
            await this.taskManager.addSteps(steps);
            
            // 작업 실행
            await this.taskManager.executeTask();
        } catch (error) {
            console.error('작업 처리 실패:', error.message);
            throw error;
        }
    }
}

export default TaskService; 