import { systemSchemas } from './system.js';
import { chatSchemas } from './chat.js';
import { codeSchemas } from './code.js';
import { agentSchemas } from './agent.js';
import { reportSchemas } from './report.js';
import { ragSchemas } from './rag.js';
import { webSchemas } from './web.js';
import { sessionSchemas } from './session.js';
import { taskSchemas } from './task.js';
import { authSchemas } from './auth.js';
import { queueSchemas } from './queue.js';
import './provider.js';

export const schemas = {
    ...systemSchemas,
    ...chatSchemas,
    ...codeSchemas,
    ...agentSchemas,
    ...reportSchemas,
    ...ragSchemas,
    ...webSchemas,
    ...sessionSchemas,
    ...taskSchemas,
    ...authSchemas,
    ...queueSchemas
};

// 태그 정의
export const tags = [
    {
        name: 'System',
        description: '시스템 관련 API'
    },
    {
        name: 'Auth',
        description: '사용자 인증 및 관리 관련 API'
    },
    {
        name: 'Chat',
        description: '채팅 관련 API'
    },
    {
        name: 'Code',
        description: '코드 생성 관련 API'
    },
    {
        name: 'Agent',
        description: '에이전트 관련 API'
    },
    {
        name: 'Report',
        description: '보고서 생성 관련 API'
    },
    {
        name: 'RAG',
        description: 'RAG(Retrieval-Augmented Generation) 관련 API'
    },
    {
        name: 'Web',
        description: '웹 검색 관련 API'
    },
    {
        name: 'Session',
        description: '세션 관리 관련 API'
    },
    {
        name: 'Task',
        description: '태스크 관리 관련 API'
    },
    {
        name: 'Providers',
        description: 'AI 프로바이더 관련 API'
    },
    {
        name: 'Queue',
        description: '큐 모니터링 및 관리 관련 API'
    }
];

// API 보안 설정 그룹화
export const securitySchemes = {
    apiKeyAuth: {
        type: 'apiKey',
        in: 'header',
        name: 'X-API-Key',
        description: 'AI 기능 사용을 위한 API 키입니다. API 키는 관리자 페이지에서 발급받을 수 있습니다.'
    },
    bearerAuth: {
        type: 'http',
        scheme: 'bearer',
        bearerFormat: 'JWT',
        description: '관리자 기능 사용을 위한 JWT 토큰입니다. 로그인 API를 통해 발급받을 수 있습니다.'
    }
};

// API 태그 그룹화
export const tagGroups = [
    {
        name: '시스템 관리',
        tags: ['System', 'Auth', 'Session', 'Providers', 'Queue']
    },
    {
        name: 'AI 기능',
        tags: ['Chat', 'Code', 'Agent', 'Report']
    },
    {
        name: '보조 기능',
        tags: ['RAG', 'Web']
    },
    {
        name: '작업 관리',
        tags: ['Task']
    }
]; 