'use client';

import { useEffect, useState } from 'react';

interface ClientOnlyProps {
  children: React.ReactNode;
  fallback?: React.ReactNode;
}

export default function ClientOnly({ children, fallback = null }: ClientOnlyProps) {
  const [hasMounted, setHasMounted] = useState(false);
  
  // 컴포넌트가 마운트된 후에만 children을 렌더링
  useEffect(() => {
    setHasMounted(true);
  }, []);
  
  // 클라이언트 측에서 마운트되기 전까지는 아무것도 렌더링하지 않음
  if (!hasMounted) {
    return <>{fallback}</>;
  }
  
  return <>{children}</>;
} 