def calculate_fibonacci(n):
    """피보나치 수열의 n번째 숫자를 계산합니다."""
    if n <= 0:
        return 0
    elif n == 1:
        return 1
    
    a, b = 0, 1
    for i in range(2, n + 1):
        a, b = b, a + b
    return b

def find_prime_numbers(limit):
    """limit까지의 모든 소수를 찾습니다."""
    primes = []
    for num in range(2, limit + 1):
        is_prime = True
        for i in range(2, num):
            if num % i == 0:
                is_prime = False
                break
        if is_prime:
            primes.append(num)
    return primes

def sort_strings(strings):
    """문자열 리스트를 정렬합니다."""
    return sorted(strings, key=lambda x: (len(x), x))

if __name__ == "__main__":
    # 피보나치 수열 테스트
    n = 10
    result = calculate_fibonacci(n)
    print(f"피보나치 수열의 {n}번째 숫자: {result}")
    
    # 소수 찾기 테스트
    limit = 20
    primes = find_prime_numbers(limit)
    print(f"{limit}까지의 소수: {primes}")
    
    # 문자열 정렬 테스트
    strings = ["apple", "banana", "cat", "dog", "elephant"]
    sorted_strings = sort_strings(strings)
    print(f"정렬된 문자열: {sorted_strings}") 