# AI.RUN 매뉴얼

## 기본 사용법
```bash
airun [options] [prompt]
```

## 명령어 옵션

### 1. 기본 옵션
- `-g, --gui`: GUI 모드로 실행
- `-r, --resetconfig`: 설정 초기화 모드
- `-e, --autoexecute`: 자동 실행 모드
- `-b, --debug <scopename>`: 디버그 모드
- `-a, --api <apimode>`: API 모드
- `-o, --output <o>`: 출력 파일 지정
- `-v, --verbose`: 상세 출력 표시
- `-q, --quiet`: 최소 출력 표시
- `-h, --help`: 도움말 표시
- `-V, --version`: 버전 정보 표시

### 2. 실행 모드 옵션
- `--chat`: 대화 모드 활성화
- `--code`: 코드 생성 모드 활성화
- `--agent`: 에이전트 모드 활성화
- `--report`: 보고서 생성 모드 활성화
- `--mode <mode>`: 프롬프트 모드 설정 (code/chat/report)

### 3. 기능 활성화 옵션
- `--rag`: RAG 기능 활성화
- `--web`: 웹 검색 기능 활성화
- `--auto`: 자동 실행 기능 활성화

### 4. 언어 관련 옵션
- `-s, --source <source>`: 소스 언어 지정 (기본값: auto)
- `-d, --destination <destination>`: 대상 언어 지정

### 5. AI 모델 관련 옵션
- `-c, --choosevendor`: AI 공급자 선택
- `-m, --choosemodel`: AI 모델 선택

### 6. 출력 관련 옵션
- `--template <template>`: 보고서 템플릿 지정 (예: simple)
- `--format <type>`: 출력 형식 지정 (pdf/hwpx/docx/pptx) (기본값: pdf)

### 7. 캐시 관련 옵션
- `--list-cache`: 캐시된 작업 목록 표시
- `--run-cache <id>`: 캐시된 작업 실행
- `--nocache`: RAG 검색 캐시 와 Web 검색 캐시 사용 안함

### 8. 캐시 관리 명령어
```bash
airun clear-cache [options]
```
웹 검색, RAG 검색, 보고서 생성 등의 캐시를 삭제합니다.

**옵션**:
- `--web-only`: 웹 검색 캐시만 삭제합니다 (위치: ~/.airun/cache/web_search)
- `--rag-only`: RAG 검색 캐시만 삭제합니다 (위치: ~/.airun/rag_cache.json)
- `--report-only`: 보고서 생성 캐시만 삭제합니다 (위치: ~/.airun/cache/report)

**사용 예시**:
```bash
# 모든 캐시 삭제
airun clear-cache

# 웹 검색 캐시만 삭제
airun clear-cache --web-only

# RAG 검색 캐시만 삭제
airun clear-cache --rag-only

# 보고서 생성 캐시만 삭제
airun clear-cache --report-only
```

### 9. Python 관련 옵션
- `--execute-python <file>`: 가상 환경에서 Python 파일 실행
- `-p, --python-command <command>`: 가상 환경에서 Python 명령어 실행

## 서브 커맨드

### 1. update
```bash
airun update
```
AI.RUN을 최신 버전으로 업데이트합니다.

### 2. rag-path
```bash
airun rag-path <path>
```
RAG 문서 저장소 경로를 설정합니다.

### 3. rag-init
```bash
airun rag-init
```
RAG 시스템을 초기화합니다. 기존의 모든 RAG 데이터와 캐시가 삭제되고 새로 초기화됩니다.

### 4. rag-add
```bash
airun rag-add [path]
```
기존 RAG 컬렉션에 새로운 문서를 추가합니다. path를 지정하지 않으면 RAG_DOCS_PATH의 문서들이 추가됩니다.

### 5. rag-precache
```bash
airun rag-precache
```
RAG 시스템의 캐시를 미리 생성하여 검색 속도를 향상시킵니다.

### 6. rag-search
```bash
airun rag-search <query>
```
RAG 컬렉션에서 문서를 검색합니다. 검색 쿼리와 관련성이 높은 문서들을 찾아 표시합니다.

### 7. auto
```bash
airun auto
```
자동 실행 모드를 토글합니다.

### 8. web
```bash
airun web
```
웹 검색 기능을 토글합니다.

### 9. rag
```bash
airun rag
```
RAG 기능을 토글합니다.

### 10. clear-cache
```bash
airun clear-cache [options]
```
캐시 데이터를 삭제합니다. 옵션을 지정하지 않으면 모든 캐시를 삭제합니다.

**옵션**:
- `--web-only`: 웹 검색 캐시만 삭제
- `--rag-only`: RAG 검색 캐시만 삭제
- `--report-only`: 보고서 생성 캐시만 삭제

## API 모드 메소드

다음 API 메소드들이 지원됩니다:

### 1. 환경 설정 관련
- `resetconfig`: 설정 초기화
- `setconfig`: 설정 값 지정
- `getconfig`: 설정 값 조회

### 2. 패키지 관련
- `neededpackages`: 필요한 패키지 목록 조회
- `installpackage`: 패키지 설치

### 3. 시스템 관련
- `shell_exec`: 셸 명령어 실행
- `createVENV`: 가상 환경 생성

### 4. AI 요청 관련

#### aireq
AI 모델에 직접 요청을 보내고 응답을 받는 메소드입니다.

**파라미터**
```json
{
    "prompt": "AI 모델에 전달할 프롬프트",
    "history": "이전 대화 기록 배열 (선택사항)",
    "messages_": "메시지 기록 배열 (선택사항)",
    "askforce": "요청 강제 실행 플래그 (기본값: '')",
    "summary": "대화 요약 (선택사항)",
    "first": "첫 요청 여부 (선택사항)",
    "contextWindowRatio": "컨텍스트 윈도우 비율 (선택사항)"
}
```

**사용 예시**
```bash
# 기본 AI 요청
airun -a aireq '{
    "prompt": "파이썬으로 간단한 웹 서버 만드는 방법을 알려주세요",
    "history": [],
    "messages_": [],
    "askforce": "",
    "summary": ""
}'

# 이전 대화 기록을 포함한 요청
airun -a aireq '{
    "prompt": "이전 코드에 로깅 기능을 추가해주세요",
    "history": [
        {"role": "user", "content": "파이썬으로 간단한 웹 서버 만드는 방법을 알려주세요"},
        {"role": "assistant", "content": "이전 응답 내용..."}
    ],
    "messages_": [],
    "askforce": "",
    "summary": "웹 서버 구현 관련 대화"
}'
```

#### assignnewprompt
현재 대화 세션에 새로운 프롬프트를 할당하는 메소드입니다. 이전 대화 맥락을 유지하면서 새로운 요청을 추가할 때 사용합니다.

**파라미터**
```json
{
    "request": "새로운 프롬프트 내용",
    "history": "이전 대화 기록 배열",
    "promptSession": "현재 프롬프트 세션 객체",
    "python_code": "이전에 생성된 파이썬 코드 (선택사항)"
}
```

**사용 예시**
```bash
# 새로운 프롬프트 할당
airun -a assignnewprompt '{
    "request": "이 코드에 에러 처리를 추가해주세요",
    "history": [
        {"role": "user", "content": "이전 요청 내용"},
        {"role": "assistant", "content": "이전 응답 내용"}
    ],
    "promptSession": {
        "prompt": "이전 프롬프트",
        "context": "현재 컨텍스트"
    }
}'
```

**응답 형식**
```json
{
    "askforce": "요청 처리 상태",
    "history": "업데이트된 대화 기록",
    "promptSession": "업데이트된 프롬프트 세션"
}
```

#### 고급 사용 예시

1. 코드 생성 요청:
```bash
airun -a aireq '{
    "prompt": "파이썬으로 REST API 서버를 만들어주세요. FastAPI를 사용해서 만들어주세요.",
    "history": [],
    "messages_": [],
    "askforce": "",
    "summary": "FastAPI 서버 구현",
    "first": true
}'
```

2. 코드 수정 요청:
```bash
airun -a aireq '{
    "prompt": "위 코드에 JWT 인증을 추가해주세요",
    "history": ["이전 대화 내용..."],
    "messages_": ["이전 메시지..."],
    "summary": "FastAPI 서버에 JWT 인증 추가"
}'
```

3. 연속적인 대화:
```bash
# 첫 번째 요청
airun -a aireq '{
    "prompt": "머신러닝 모델을 학습하는 파이썬 코드를 작성해주세요",
    "history": [],
    "messages_": [],
    "askforce": "",
    "summary": "ML 모델 학습 코드"
}'

# 두 번째 요청 (새로운 프롬프트 할당)
airun -a assignnewprompt '{
    "request": "이 모델에 교차 검증을 추가해주세요",
    "history": ["이전 대화 내용..."],
    "promptSession": {"이전 세션 정보..."}
}'
```

## 환경 설정 변수

`~/.airun/airun.conf` 파일에서 설정할 수 있는 주요 환경 변수들입니다:

### 1. 시스템 설정
- `UPDATE_CHECK`: 업데이트 확인 여부 (yes/no)
- `AUTO_UPDATE`: 자동 업데이트 여부 (yes/no)
- `THEME`: UI 테마 설정 (light/dark)
- `LANGUAGE`: 기본 언어 설정 (ko/en/ja/zh)
- `AIMODE`: AI 모드 설정 (chat/code/report)
- `USE_LLM`: 사용할 LLM 설정 (ollama/openai/anthropic/gemini/groq)

### 2. AI 모델 설정
- `OPENAI_API_KEY`: OpenAI API 키
- `OPENAI_MODEL`: OpenAI 모델 설정
- `ANTHROPIC_API_KEY`: Anthropic API 키
- `ANTHROPIC_MODEL`: Anthropic 모델 설정
- `GROQ_MODEL`: Groq 모델 설정
- `GEMINI_MODEL`: Gemini 모델 설정
- `OLLAMA_MODEL`: Ollama 모델 설정
- `TEMPERATURE`: AI 응답의 창의성 정도 (0.0 ~ 1.0)

### 3. Python 환경 설정
- `PYTHON_VENV_PATH`: Python 가상 환경 경로
- `TRANSFORMERS_CACHE`: Transformers 캐시 경로
- `HF_HOME`: Hugging Face 홈 디렉토리

### 4. RAG 설정
- `RAG_DOCS_PATH`: RAG 문서 저장소 경로
- `RAG_CHUNK_SIZE`: 문서 청크 크기
- `RAG_CHUNK_OVERLAP`: 청크 간 중복 크기
- `RAG_TOP_K`: 검색 결과 상위 K개
- `RAG_SIMILARITY_THRESHOLD`: 유사도 임계값
- `RAG_KEYWORD_MATCH_THRESHOLD`: 키워드 매칭 임계값
- `RAG_STRONG_KEYWORD_MATCH_THRESHOLD`: 강력 키워드 매칭 임계값

### 5. 기능 활성화 설정
- `USE_SMTP`: SMTP 사용 여부 (YES/NO)
- `SMTP_HOST`: SMTP 서버 호스트
- `SMTP_PORT`: SMTP 서버 포트
- `SMTP_USERNAME`: SMTP 사용자 이름
- `SMTP_PASSWORD`: SMTP 비밀번호
- `SMTP_SECURE`: SMTP 보안 연결 여부 (YES/NO)
- `HIDE_CODE`: 코드 숨김 여부 (yes/no)
- `AUTO_PROVIDER_SELECTION`: 자동 공급자 선택 여부 (yes/no)
- `AUTO_EXECUTE`: 자동 실행 여부 (yes/no)
- `USE_REVIEW`: 코드 리뷰 사용 여부 (yes/no)
- `USE_WEB_SEARCH`: 웹 검색 사용 여부 (yes/no)
- `USE_RAG`: RAG 기능 사용 여부 (yes/no)

## 사용자 정의 도구 (User Tools)

### 1. 개요
사용자 정의 도구는 `~/.airun/venv/lib/python3.x/site-packages/user_tools.py` 파일에서 관리됩니다.

### 2. 사용 예시
```python
from user_tools import DBQueryTool

# DB 도구 생성
db = DBQueryTool()

try:
    # DB 연결
    db.connect(
        db_type="mysql",
        host="localhost",
        port=3306,
        database="test_db",
        username="user",
        password="pass"
    )
    
    # 쿼리 실행 및 결과 저장
    query = "SELECT * FROM users WHERE age > :min_age"
    db.execute(
        query=query,
        output_path="users.csv",
        params={"min_age": 20}
    )
    
finally:
    # 연결 종료
    db.close()
```
