# AI.RUN ヘルプ

## 🌟 はじめに
AI.RUNは、様々なAIモデルを統合・調整し、実際のシステムタスクを実行できる強力なAIエージェントオーケストレーションツールです。

## 📱 使用方法

### AIチャット
AIとチャットしてタスクを要求できるメイン画面です。
- **基本的な使い方**
  - チャットウィンドウに質問やタスクを入力
  - 右上からAIモデルを選択
  - 送信ボタンを押してチャットを開始
- **チャット/実行モード**
  - チャットモード: AIと自由に情報交換
  - 実行モード: システムコマンドやファイル操作などの直接的なタスクを実行
- **プロンプト設定**
  - 設定 > AI設定でプロンプトをカスタマイズ
  - タスクの目的に合わせたプロンプトの設定
  - 様々なタスクタイプに最適化されたプロンプト

### 環境設定
システム全般の設定を管理します。

- **AIモデル設定**
  - AIプロバイダーの選択 (OpenAI, Anthropic, Ollama, Gemini, Groq)
  - APIキーの登録と管理
  - モデルの選択と設定

- **チャット設定**
  - コマンド実行前の確認
  - 自動実行設定
  - テーマ設定 (ダーク/ライト)
  - 言語設定 (韓国語、英語、日本語、中国語、スペイン語、フランス語)

- **RAG設定**
  - RAG機能の使用有無
  - 文書パスの設定
  - データベース初期化と文書処理

- **SMTP設定**
  - メールサーバーホスト
  - ポート番号
  - ユーザーアカウント
  - セキュア接続設定

- **追加機能**
  - Web検索の使用
  - セッション初期化
  - 設定初期化

### AI設定
AIとの対話のためのプロンプトを管理する画面です。

- **プロンプト編集**
  - 現在使用中のプロンプト内容の確認
  - プロンプトの直接編集と保存
  - デフォルトへのリセット可能

- **RAGプロンプト**
  - RAG機能のための特別なプロンプト適用
  - 文書検索と参照のための最適化されたプロンプト
  - 知識ベースの応答生成のための設定

- **主な機能**
  - プロンプトのリアルタイム保存
  - デフォルトプロンプトの復元
  - RAGプロンプトの適用
  - プロンプトプレビュー

### タスク管理
よく使用するAIタスクを保存・管理する画面です。
- **タスク登録方法**
  1. 直接登録
     - '新規タスク'ボタンで新しいタスクを作成
     - タスク名と説明を作成
     - AIへの指示内容を事前に作成
  2. チャットからの登録
     - チャットで成功したタスクの'タスク登録'ボタンをクリック
     - タスク名と説明を追加
     - 実行されたタスク内容が自動的に保存

- **キャッシュタスク**
  - チャットから実行成功したタスクを登録すると自動的にキャッシュタスクを作成
  - AI呼び出しなしで保存されたコードがすぐに実行される高速レスポンス
  - タスク実行コストの削減効果
  - 頻繁に使用するシステムタスクに特に有用

- **タスク管理**
  - タスクリストでステータス確認と実行/停止
  - タスク内容の修正と削除
  - 実行履歴の確認
  - キャッシュタスクの更新管理

### 使用統計
AIモデルの使用量とコストを確認する画面です。
- **全体サマリー**
  - 総コストと総トークン使用量
  - 今月のコストとトークン使用量
  - トレンド分析と比較

- **プロバイダー別分析**
  - AIプロバイダー別のコストとトークン使用量
  - リクエスト数統計
  - プロバイダー別コスト分布チャート

- **詳細分析**
  - 月別使用量トレンド
  - 時間帯別使用量分布
  - モデル別トークン使用量比較
  - モデル別コスト効率性分析

- **セッション別分析**
  - セッション別使用量分布
  - 初期プロンプト内容
  - セッション別コストとトークン統計

- **詳細履歴**
  - AI呼び出し詳細履歴テーブル
  - 時間、プロバイダー、モデル、トークン、コスト情報
  - CSV形式ダウンロード対応

### 実行履歴
AIとの対話中に実行されたすべてのコマンドと結果を確認する画面です。
- **実行記録**
  - 実行時間とステータス(成功/失敗)表示
  - ユーザークエリ内容
  - 実行されたコード
  - 実行結果

## 🚀 主な機能

### 1. AIエージェントオーケストレーション
- **マルチプロバイダー統合**
  - OpenAI、Anthropic、Ollama、Google、Groqなど様々なAIモデルを活用
  - ローカル実行(Ollama)とクラウドサービスを柔軟に選択
  - プロバイダー障害時の自動フェイルオーバー対応
  - コスト/パフォーマンス最適化に基づくプロバイダー選択

- **プロンプト最適化**
  - モデル別特性に合わせたプロンプトテンプレート提供
  - トークン使用量のリアルタイムモニタリング
  - コンテキスト圧縮と最適化
  - 多言語プロンプト対応

### 2. 文書処理と知識管理
- **RAG (Retrieval-Augmented Generation)**
  - Xenova/all-MiniLM-L6-v2モデルベースの高性能エンベディング
  - ChromaDB + SQLiteの組み合わせによる安定的なベクターデータ管理
  - ハイブリッド検索: 意味+キーワード結合検索
  - 動的文書チャンク分割とメタデータ管理

- **様々な文書フォーマット対応**
  - HWP、PDF、MS Office文書の原本処理
  - 表/画像の抽出と処理
  - 自動メタデータ抽出とタグ付け
  - 大容量文書の一括処理

### 3. システム統合と自動化
- **タスク管理システム**
  - 繰り返しタスクの自動化とスケジューリング
  - タスク実行結果の追跡
  - リアルタイムモニタリングと通知
  - タスク履歴管理と再利用

- **システム統合**
  - ファイルシステムの直接アクセスと操作
  - システムコマンドの実行と自動化
  - ローカルプログラム制御
  - 開発環境の自動構成

### 4. WebとEmail統合
- **統合Web検索**
  - Google、Naver、Daumなど多言語検索エンジン統合
  - Seleniumベースの安定的な検索
  - 検索結果の自動分析と抽出
  - キャッシュシステムによる応答速度最適化

- **Email機能**
  - HTMLテンプレート対応
  - 大量メール送信
  - 添付ファイル処理
  - メール自動応答と分類

### 5. 開発者ツール
- **コード管理**
  - ASTベースのコード分析
  - コード生成と最適化
  - マルチランタイム対応 (Node.js, Python)
  - サンドボックス実行環境

- **パッケージ管理**
  - 依存関係の自動解決
  - バージョン互換性チェック
  - セキュリティ脆弱性チェック
  - 仮想環境管理

## 💡 主な利点

### 1. コスト最適化
- **キャッシングシステム**
  - RAG検索結果のキャッシング (TTL: 72時間)
  - Web検索結果のキャッシング
  - エンベディング結果のキャッシング
  - コレクション情報のキャッシング

- **リソース使用最適化**
  - トークン使用量モニタリング
  - コスト効率的なモデル自動選択
  - バッチ処理最適化
  - 重複リクエスト防止

### 2. パフォーマンスと安定性
- **高性能アーキテクチャ**
  - Node.jsとPythonのハイブリッド構造
  - プロセス分離による安定性
  - マルチスレッド処理
  - メモリ使用最適化

- **エラー処理と復旧**
  - 自動再試行メカニズム
  - 障害復旧システム
  - 詳細エラーログ
  - 自動バックアップと復旧

### 3. セキュリティとコンプライアンス
- **データセキュリティ**
  - ローカル環境実行によるデータ漏洩防止
  - 機密情報の自動検出とマスキング
  - アクセス制御と権限管理
  - ISMS-P、GDPRなど規制準拠

- **モニタリングと監査**
  - タスク実行ログ記録
  - リソース使用量モニタリング
  - セキュリティ監査レポート
  - リアルタイムアラートシステム

## 📊 性能指標
- RAG検索応答時間
  * キャッシュミス: 4~5秒
  * キャッシュヒット: 0.002-0.005秒
- Web検索応答時間
  * 初期検索: 4~5秒
  * キャッシュヒット: 0.001秒
- 文書処理性能
  * 推奨文書量: 5,000-10,000ページ
  * 最大処理量: 20,000-30,000ページ

## 📞 テクニカルサポート
- メール: sales@invesume.com
- ウェブサイト: https://invesume.com
- 電話: 02-2039-3977 / 010-3838-8378 