# airun bash completion script

_airun_completion() {
    local cur prev opts cmds
    COMPREPLY=()
    cur="${COMP_WORDS[COMP_CWORD]}"
    prev="${COMP_WORDS[COMP_CWORD-1]}"

    # List of available commands (actual subcommands)
    cmds="auto auto-analyze auto-provider web rag rag-init rag-init-local rag-init-force rag-queue-status rag-path rag-precache rag-add rag-remove rag-search web-search task set update clear-cache api-server-start api-server-stop api-server-status tools"

    # List of available options (actual options)
    opts="-r --resetconfig \
          -s --source \
          -d --destination \
          -c --choosevendor \
          -m --choosemodel \
          --mode \
          -b --debug \
          -a --api \
          -e --autoexecute \
          --auto-analyze \
          --auto-provider \
          -o --output \
          -g --gui \
          --execute-python \
          -p --python-command \
          --list-cache \
          --run-cache \
          --chat \
          --code \
          --agent \
          --report \
          --task \
          --template \
          --rag \
          --user \
          --web \
          --auto \
          --format \
          --nocache \
          -v --verbose \
          -q --quiet \
          -h --help \
          -V --version"

    # Values that can follow specific options
    case "${prev}" in
        --mode)
            # Available modes
            local modes="code chat agent report"
            COMPREPLY=( $(compgen -W "${modes}" -- "${cur}") )
            return 0
            ;;
        --source|-s|--destination|-d)
            # Available language codes
            local langs="ko en ja zh fr de es it ru pt hi vi auto"
            COMPREPLY=( $(compgen -W "${langs}" -- "${cur}") )
            return 0
            ;;
        --choosevendor|-c)
            # Available AI vendors
            local vendors="openai anthropic gemini groq ollama vllm"
            COMPREPLY=( $(compgen -W "${vendors}" -- "${cur}") )
            return 0
            ;;
        --choosemodel|-m)
            # All models defined in constants.js
            local models="llama-3.1-405b-reasoning \
                         llama-3.1-70b-versatile \
                         llama3-8b-8192 \
                         llama3-70b-8192 \
                         mixtral-8x7b-32768 \
                         gemma-7b-it \
                         llama3:latest \
                         llama3:8b-instruct-q8_0 \
                         llama3:70b \
                         gemini-1.5-pro \
                         gemini-1.5-flash \
                         gemini-2.0-flash-exp \
                         gpt-4o \
                         gpt-4o-mini \
                         gpt-4-turbo \
                         gpt-4 \
                         gpt-3.5-turbo \
                         claude-3-5-sonnet-20241022 \
                         claude-3-opus-20240229 \
                         claude-3-haiku-20240307"
            COMPREPLY=( $(compgen -W "${models}" -- "${cur}") )
            return 0
            ;;
        --format)
            # Available output formats
            local formats="pdf hwpx docx pptx"
            COMPREPLY=( $(compgen -W "${formats}" -- "${cur}") )
            return 0
            ;;
        --template)
            # Available report templates
            local templates="simple bizplan proposal startup thesis"
            COMPREPLY=( $(compgen -W "${templates}" -- "${cur}") )
            return 0
            ;;
        --chat)
            # Chat mode with optional message - no specific completion needed
            return 0
            ;;
        --code)
            # Code generation mode with optional prompt - no specific completion needed
            return 0
            ;;
        --engine)
            # Available search engines for web-search
            local engines="google naver daum parallel auto"
            COMPREPLY=( $(compgen -W "${engines}" -- "${cur}") )
            return 0
            ;;
        rag-path|rag-add|rag-remove)
            # Directory autocompletion
            COMPREPLY=( $(compgen -d -- "${cur}") )
            return 0
            ;;
        --execute-python|--python-command|-p)
            # Python file autocompletion
            COMPREPLY=( $(compgen -f -X '!*.py' -- "${cur}") )
            return 0
            ;;
        clear-cache)
            # Special options for clear-cache command
            local cache_opts="--web-only --rag-only --report-only --task-only"
            COMPREPLY=( $(compgen -W "${cache_opts}" -- "${cur}") )
            return 0
            ;;
        api-server-start)
            # Special options for api-server-start command
            local api_opts="--port --host --foreground"
            COMPREPLY=( $(compgen -W "${api_opts}" -- "${cur}") )
            return 0
            ;;
        tools)
            # Tool management subcommands
            local tool_cmds="list info test create reload stats"
            COMPREPLY=( $(compgen -W "${tool_cmds}" -- "${cur}") )
            return 0
            ;;
        web-search)
            # web-search command options
            local web_opts="--engine --max-results"
            COMPREPLY=( $(compgen -W "${web_opts}" -- "${cur}") )
            return 0
            ;;
        rag-add)
            # rag-add command options
            local rag_add_opts="--user"
            COMPREPLY=( $(compgen -W "${rag_add_opts}" -- "${cur}") )
            return 0
            ;;
    esac

    # Handle command-specific completions
    if [[ ${#COMP_WORDS[@]} -gt 2 ]]; then
        local cmd="${COMP_WORDS[1]}"
        case "$cmd" in
            tools)
                if [[ ${#COMP_WORDS[@]} -eq 3 ]]; then
                    # First argument after 'tools' should be subcommand
                    local tool_cmds="list info test create reload stats"
                    COMPREPLY=( $(compgen -W "${tool_cmds}" -- "${cur}") )
                    return 0
                elif [[ ${#COMP_WORDS[@]} -eq 4 ]]; then
                    local subcmd="${COMP_WORDS[2]}"
                    case "$subcmd" in
                        info|test|create)
                            # These subcommands need tool name
                            COMPREPLY=( $(compgen -W "toolName" -- "${cur}") )
                            return 0
                            ;;
                    esac
                fi
                ;;
            web-search|rag-search|task|set)
                # These commands expect arguments, no specific completion
                return 0
                ;;
        esac
    fi

    # Command autocompletion
    if [[ ${cur} == * ]] ; then
        if [[ ${cur} == -* ]] ; then
            # Option autocompletion
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
        else
            # Subcommand autocompletion
            COMPREPLY=( $(compgen -W "${cmds}" -- "${cur}") )
        fi
    fi
}

complete -F _airun_completion airun 