import { NextRequest } from 'next/server';
import { exec } from 'child_process';
import path from 'path';

export async function POST(req: NextRequest) {
  const scriptPath = path.join(process.cwd(), '/src/app/admin/evaluation/ollama_eval_judge.py');
  return new Promise((resolve) => {
    exec(`python3 "${scriptPath}"`, (error, stdout, stderr) => {
      if (error) {
        resolve(new Response(JSON.stringify({ error: stderr }), { status: 500 }));
      } else {
        resolve(new Response(JSON.stringify({ message: '평가 실행 완료', output: stdout }), { status: 200 }));
      }
    });
  });
} 