import { useState } from 'react';
import type { NodeConfigProps } from './types';

export default function ConditionNodeConfig({ node, onNodeUpdate }: NodeConfigProps) {
  const [localConfig, setLocalConfig] = useState(node.data.config || {});
  const [localData, setLocalData] = useState(node.data);

  const updateConfig = (key: string, value: any) => {
    const newConfig = { ...localConfig, [key]: value };
    setLocalConfig(newConfig);
    onNodeUpdate(node.id, {
      data: {
        ...localData,
        config: newConfig,
      },
    });
  };

  const updateData = (key: string, value: any) => {
    const newData = { ...localData, [key]: value };
    setLocalData(newData);
    onNodeUpdate(node.id, {
      data: newData,
    });
  };

  return (
    <div className="space-y-4">
      <div>
        <label className="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
          조건식
        </label>
        <textarea
          value={localData.condition || ''}
          onChange={(e) => updateData('condition', e.target.value)}
          placeholder="조건을 작성하세요 (예: value > 100)"
          className="w-full px-3 py-2 bg-transparent border border-gray-200 dark:border-gray-700 rounded-xl text-gray-900 dark:text-gray-100 focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-all duration-150 h-20 resize-none"
        />
      </div>

      <div>
        <label className="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
          연산자
        </label>
        <select
          value={localConfig.operator || 'equals'}
          onChange={(e) => updateConfig('operator', e.target.value)}
          className="w-full px-3 py-2 bg-white dark:bg-gray-800 border border-gray-200 dark:border-gray-700 rounded-xl text-gray-900 dark:text-gray-100 focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-all duration-150"
        >
          <option value="equals">같음 (==)</option>
          <option value="not_equals">다름 (!=)</option>
          <option value="greater">보다 큼 (&gt;)</option>
          <option value="less">보다 작음 (&lt;)</option>
          <option value="contains">포함</option>
          <option value="regex">정규표현식</option>
        </select>
      </div>

      <div>
        <label className="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
          비교값
        </label>
        <input
          type="text"
          value={localConfig.compareValue || ''}
          onChange={(e) => updateConfig('compareValue', e.target.value)}
          placeholder="비교할 값을 입력하세요"
          className="w-full px-3 py-2 bg-white dark:bg-gray-800 border border-gray-200 dark:border-gray-700 rounded-xl text-gray-900 dark:text-gray-100 focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-all duration-150"
        />
      </div>

      <div className="flex items-center">
        <input
          type="checkbox"
          id="caseSensitive"
          checked={localConfig.caseSensitive || false}
          onChange={(e) => updateConfig('caseSensitive', e.target.checked)}
          className="w-4 h-4 text-blue-600 bg-gray-100 dark:bg-gray-700 border-gray-300 dark:border-gray-600 rounded focus:ring-blue-500 focus:ring-2 mr-3"
        />
        <label htmlFor="caseSensitive" className="text-sm font-medium text-gray-700 dark:text-gray-300">
          대소문자 구분
        </label>
      </div>
    </div>
  );
}