from fastapi import FastAPI, HTTPException, Depends
from pydantic import BaseModel
from typing import List, Optional
import jwt
from datetime import datetime, timedelta

app = FastAPI(title="User Management API")

class User(BaseModel):
    id: Optional[int]
    username: str
    email: str
    role: str = "user"

class UserCreate(BaseModel):
    username: str
    email: str
    password: str

class UserUpdate(BaseModel):
    username: Optional[str]
    email: Optional[str]
    role: Optional[str]

@app.post("/users/", response_model=User, tags=["users"])
async def create_user(user: UserCreate):
    """
    사용자 생성 API
    
    Parameters:
    - username: 사용자명
    - email: 이메일
    - password: 비밀번호
    
    Returns:
    - User 객체
    """
    # 사용자 생성 로직
    return {"id": 1, "username": user.username, "email": user.email, "role": "user"}

@app.get("/users/{user_id}", response_model=User, tags=["users"])
async def get_user(user_id: int):
    """
    사용자 조회 API
    
    Parameters:
    - user_id: 사용자 ID
    
    Returns:
    - User 객체
    """
    # 사용자 조회 로직
    return {"id": user_id, "username": "test_user", "email": "test@example.com", "role": "user"}

@app.put("/users/{user_id}", response_model=User, tags=["users"])
async def update_user(user_id: int, user: UserUpdate):
    """
    사용자 정보 수정 API
    
    Parameters:
    - user_id: 사용자 ID
    - user: 수정할 사용자 정보
    
    Returns:
    - 수정된 User 객체
    """
    # 사용자 정보 수정 로직
    return {"id": user_id, "username": user.username, "email": user.email, "role": user.role}

@app.delete("/users/{user_id}", tags=["users"])
async def delete_user(user_id: int):
    """
    사용자 삭제 API
    
    Parameters:
    - user_id: 사용자 ID
    
    Returns:
    - 성공 메시지
    """
    # 사용자 삭제 로직
    return {"message": "User deleted successfully"} 