# Aide AI.RUN

## 🌟 Introduction
AI.RUN est un puissant outil d'orchestration d'agents IA qui intègre et coordonne divers modèles d'IA pour exécuter des tâches système réelles.

## 📱 Comment Utiliser

### Chat IA
Écran principal où vous pouvez discuter avec l'IA et demander des tâches.
- **Utilisation de Base**
  - Saisissez des questions ou des tâches dans la fenêtre de chat
  - Sélectionnez le modèle d'IA dans le coin supérieur droit
  - Cliquez sur le bouton d'envoi pour démarrer le chat
- **Mode Chat/Exécution**
  - Mode Chat : Échange libre d'informations avec l'IA
  - Mode Exécution : Exécution directe de commandes système et d'opérations sur fichiers
- **Configuration des Prompts**
  - Personnalisez les prompts dans Paramètres > Configuration IA
  - Configurez des prompts personnalisés selon l'objectif de la tâche
  - Optimisez les prompts pour différents types de tâches

### Configuration de l'Environnement
Gérez la configuration générale du système.

- **Configuration des Modèles IA**
  - Sélection des fournisseurs IA (OpenAI, Anthropic, Ollama, Gemini, Groq)
  - Enregistrement et gestion des clés API
  - Sélection et configuration des modèles

- **Configuration du Chat**
  - Confirmation avant l'exécution des commandes
  - Configuration de l'exécution automatique
  - Configuration du thème (sombre/clair)
  - Configuration de la langue (coréen, anglais, japonais, chinois, espagnol, français)

- **Configuration RAG**
  - Options d'utilisation RAG
  - Configuration du chemin des documents
  - Initialisation de la base de données et traitement des documents

- **Configuration SMTP**
  - Hôte du serveur de messagerie
  - Numéro de port
  - Compte utilisateur
  - Configuration de connexion sécurisée

- **Fonctions Supplémentaires**
  - Utilisation de la recherche web
  - Initialisation de session
  - Initialisation des paramètres

### Configuration IA
Interface pour gérer les prompts pour le chat IA.

- **Édition des Prompts**
  - Voir le contenu des prompts actuels
  - Modifier et sauvegarder directement les prompts
  - Réinitialiser aux valeurs par défaut

- **Prompts RAG**
  - Prompts spéciaux pour la fonction RAG
  - Prompts optimisés pour la recherche et la référence de documents
  - Configuration de génération de réponses de base de connaissances

- **Fonctions Principales**
  - Sauvegarde en temps réel des prompts
  - Restaurer les prompts par défaut
  - Appliquer les prompts RAG
  - Aperçu des prompts

### Gestion des Tâches
Interface pour sauvegarder et gérer les tâches IA courantes.
- **Méthodes d'Enregistrement des Tâches**
  1. Enregistrement Direct
     - Créer une nouvelle tâche avec le bouton 'Nouvelle Tâche'
     - Écrire le nom et la description de la tâche
     - Écrire préalablement le contenu des instructions IA
  2. Enregistrement depuis le Chat
     - Cliquer sur le bouton 'Enregistrer la Tâche' d'une tâche exécutée avec succès
     - Ajouter le nom et la description de la tâche
     - Sauvegarder automatiquement le contenu de la tâche exécutée

- **Tâches en Cache**
  - Créer automatiquement des tâches en cache lors de l'enregistrement de tâches réussies depuis le chat
  - Exécuter rapidement le code sauvegardé sans appels IA
  - Réduire les coûts d'exécution des tâches
  - Particulièrement utile pour les tâches système fréquentes

- **Gestion des Tâches**
  - Voir l'état et exécuter/arrêter dans la liste des tâches
  - Modifier et supprimer le contenu des tâches
  - Voir l'historique d'exécution
  - Gérer les mises à jour des tâches en cache

### Statistiques d'Utilisation
Interface pour voir l'utilisation et les coûts des modèles IA.
- **Résumé Général**
  - Coût total et utilisation totale des tokens
  - Coût et utilisation des tokens du mois en cours
  - Analyse et comparaison des tendances

- **Analyse par Fournisseur**
  - Coût et utilisation des tokens par fournisseur IA
  - Statistiques du nombre de requêtes
  - Graphiques de distribution des coûts par fournisseur

- **Analyse Détaillée**
  - Tendances d'utilisation mensuelle
  - Distribution d'utilisation par période
  - Comparaison d'utilisation des tokens par modèle
  - Analyse d'efficacité des coûts par modèle

- **Analyse des Sessions**
  - Distribution d'utilisation par session
  - Contenu des prompts initiaux
  - Statistiques de coût et tokens par session

- **Enregistrements Détaillés**
  - Tableau des enregistrements détaillés des appels IA
  - Informations de temps, fournisseur, modèle, tokens, coût
  - Support de téléchargement au format CSV

### Historique d'Exécution
Interface pour voir toutes les commandes exécutées et les résultats dans le chat IA.
- **Enregistrements d'Exécution**
  - Affiche le temps et l'état d'exécution (succès/échec)
  - Contenu de la requête utilisateur
  - Code exécuté
  - Résultats d'exécution

## 🚀 Fonctions Principales

### 1. Orchestration d'Agents IA
- **Intégration Multi-fournisseurs**
  - Utilise divers modèles IA comme OpenAI, Anthropic, Ollama, Google, Groq
  - Sélection flexible entre exécution locale (Ollama) et services cloud
  - Support de basculement automatique en cas de défaillance du fournisseur
  - Sélection du fournisseur basée sur l'optimisation coût/performance

- **Optimisation des Prompts**
  - Fournit des modèles de prompts adaptés aux caractéristiques de chaque modèle
  - Surveillance en temps réel de l'utilisation des tokens
  - Compression et optimisation du contexte
  - Support de prompts multilingues

### 2. Traitement de Documents et Gestion des Connaissances
- **RAG (Génération Augmentée par Récupération)**
  - Embeddings haute performance basés sur le modèle Xenova/all-MiniLM-L6-v2
  - Gestion stable des données vectorielles avec combinaison ChromaDB + SQLite
  - Recherche hybride : combinaison recherche sémantique + mots-clés
  - Division dynamique des blocs de documents et gestion des métadonnées

- **Support de Multiples Formats de Documents**
  - Traitement natif des documents HWP, PDF, MS Office
  - Extraction et traitement des tableaux/images
  - Extraction et étiquetage automatique des métadonnées
  - Traitement par lots de documents volumineux

### 3. Intégration et Automatisation du Système
- **Système de Gestion des Tâches**
  - Automatisation et planification des tâches répétitives
  - Suivi des résultats d'exécution des tâches
  - Surveillance et notifications en temps réel
  - Gestion et réutilisation de l'historique des tâches

- **Intégration Système**
  - Accès direct et opération du système de fichiers
  - Exécution et automatisation des commandes système
  - Contrôle des programmes locaux
  - Configuration automatique de l'environnement de développement

### 4. Intégration Web et Email
- **Recherche Web Intégrée**
  - Intégration de moteurs de recherche multilingues comme Google, Naver, Daum
  - Recherche stable basée sur Selenium
  - Analyse et extraction automatique des résultats de recherche
  - Optimisation de la vitesse de réponse utilisant le système de cache

- **Fonctionnalité Email**
  - Support de modèles HTML
  - Envoi d'emails en masse
  - Traitement des pièces jointes
  - Réponse et classification automatique des emails

### 5. Outils de Développement
- **Gestion de Code**
  - Analyse de code basée sur AST
  - Génération et optimisation de code
  - Support de multiples environnements d'exécution (Node.js, Python)
  - Environnement d'exécution sandbox

- **Gestion des Paquets**
  - Résolution automatique des dépendances
  - Vérification de compatibilité des versions
  - Vérification des vulnérabilités de sécurité
  - Gestion des environnements virtuels

## 💡 Avantages Principaux

### 1. Optimisation des Coûts
- **Système de Cache**
  - Cache des résultats de recherche RAG (TTL : 72 heures)
  - Cache des résultats de recherche web
  - Cache des résultats d'embeddings
  - Cache d'informations agrégées

- **Optimisation d'Utilisation des Ressources**
  - Surveillance de l'utilisation des tokens
  - Sélection automatique de modèle basée sur le rapport coût-bénéfice
  - Optimisation du traitement par lots
  - Prévention des requêtes dupliquées

### 2. Performance et Stabilité
- **Architecture Haute Performance**
  - Structure hybride Node.js et Python
  - Stabilité par isolation des processus
  - Traitement multi-thread
  - Optimisation de l'utilisation de la mémoire

- **Gestion et Récupération d'Erreurs**
  - Mécanisme de réessai automatique
  - Système de récupération de pannes
  - Journal d'erreurs détaillé
  - Sauvegarde et récupération automatique

### 3. Sécurité et Conformité
- **Sécurité des Données**
  - Prévention des fuites de données par exécution en environnement local
  - Détection et masquage automatique des informations sensibles
  - Contrôle d'accès et gestion des permissions
  - Conformité aux normes comme ISMS-P, GDPR

- **Surveillance et Audit**
  - Journal d'exécution des tâches
  - Surveillance de l'utilisation des ressources
  - Rapports d'audit de sécurité
  - Système d'alertes en temps réel

## 📊 Métriques de Performance
- Temps de réponse recherche RAG
  * Sans cache : 4~5 secondes
  * Avec cache : 0.002-0.005 secondes
- Temps de réponse recherche web
  * Recherche initiale : 4~5 secondes
  * Avec cache : 0.001 secondes
- Performance de traitement des documents
  * Volume recommandé : 5,000-10,000 pages
  * Volume maximum : 20,000-30,000 pages

## 📞 Support Technique
- Email : sales@invesume.com
- Site web : https://invesume.com
- Téléphone : 02-2039-3977 / 010-3838-8378 