# AIRUN 오프라인 설치 스크립트

## 개요

이 디렉토리에는 인터넷 연결이 없는 환경에서 AIRUN을 설치하기 위한 스크립트가 포함되어 있습니다.

## 스크립트 목록

### 1. `prepare-offline-package.sh` ⭐ 권장
**온라인 환경에서 실행** - 완전한 오프라인 설치 패키지를 자동으로 준비합니다.

```bash
sudo ./prepare-offline-package.sh
```

**수행 작업:**
- Debian 패키지 및 의존성 다운로드
- Python wheels 다운로드 (PyTorch CUDA 12.9 포함)
- AI 모델 다운로드 (KURE-v1, KR-SBERT, CLIP)
- Docker 이미지 저장
- Node.js 바이너리 다운로드
- 설치 스크립트 및 문서 생성
- 선택적으로 압축 파일 생성

**출력:**
- `offline-package-YYYYMMDD-HHMMSS/` 디렉토리
- `airun-offline-YYYYMMDD.tar.gz` (선택사항)

**예상 시간:** 30-60분 (인터넷 속도에 따라)
**필요 공간:** 15-25GB

---

### 2. `create-offline-repo.sh`
**온라인 환경에서 실행** - Debian 패키지만 다운로드합니다.

```bash
sudo ./create-offline-repo.sh
```

**수행 작업:**
- 모든 시스템 의존성 패키지 다운로드
- 로컬 APT 저장소 생성
- Packages.gz 인덱스 생성

**출력:**
- `../offline-repo/packages/` 디렉토리
- `INSTALL.md` 설치 가이드

**사용 시기:**
- 시스템 패키지만 필요한 경우
- 수동으로 단계별 준비를 원하는 경우

---

### 3. `download-python-wheels.sh`
**온라인 환경에서 실행** - Python 패키지만 다운로드합니다.

```bash
./download-python-wheels.sh
```

**수행 작업:**
- requirements-linux.txt에서 패키지 다운로드
- requirement-system.txt에서 패키지 다운로드
- PyTorch CUDA 12.9 wheel 다운로드
- 모든 의존성 다운로드

**출력:**
- `../offline-repo/python-wheels/` 디렉토리
- `install-wheels.sh` 설치 스크립트

**사용 시기:**
- Python 패키지만 업데이트하는 경우
- 시스템 패키지는 이미 준비된 경우

---

### 4. `install-offline.sh`
**오프라인 환경에서 실행** - 오프라인 패키지를 사용하여 AIRUN을 설치합니다.

```bash
sudo ./install-offline.sh
```

**전제 조건:**
- 오프라인 저장소가 준비되어 있어야 함
- `offline-repo/` 디렉토리가 접근 가능해야 함

**수행 작업:**
- 오프라인 저장소 자동 감지
- 로컬 APT 저장소 설정
- 시스템 패키지 설치
- Python 환경 설정
- AI 모델 배치
- 서비스 설정 및 시작

**사용 시기:**
- 오프라인 환경에서 AIRUN 설치 시
- 기존 install.sh 대신 사용

---

## 빠른 시작 가이드

### 온라인 환경 (패키지 준비)

```bash
# 1. AIRUN 소스코드 디렉토리로 이동
cd /path/to/airun

# 2. 완전한 오프라인 패키지 생성 (권장)
cd scripts
sudo ./prepare-offline-package.sh

# 3. 생성된 패키지를 오프라인 시스템으로 전송
# USB, 네트워크 공유 등 사용
```

### 오프라인 환경 (설치)

```bash
# 1. 오프라인 패키지 압축 해제 (필요시)
tar -xzf airun-offline-YYYYMMDD.tar.gz

# 2. 패키지 디렉토리로 이동
cd offline-package-YYYYMMDD-HHMMSS

# 3. 초기 설정 실행
sudo ./setup.sh

# 4. AIRUN 설치 실행
cd scripts
sudo ./install-offline.sh
```

---

## 고급 사용법

### 개별 구성요소만 준비

시스템 패키지만:
```bash
sudo ./create-offline-repo.sh
```

Python 패키지만:
```bash
./download-python-wheels.sh
```

### 기존 패키지 업데이트

```bash
# 온라인 환경에서
cd scripts

# Python 패키지 재다운로드
./download-python-wheels.sh

# 또는 전체 재생성
sudo ./prepare-offline-package.sh
```

### 커스텀 패키지 추가

`create-offline-repo.sh` 편집:
```bash
# PACKAGES 배열에 추가
PACKAGES=(
    ...existing packages...
    "your-custom-package"
)
```

---

## 문제 해결

### 스크립트 실행 권한 오류
```bash
chmod +x scripts/*.sh
```

### 오프라인 저장소를 찾을 수 없음
```bash
# install-offline.sh가 다음 위치에서 자동으로 검색합니다:
# - ../offline-repo
# - ../../offline-repo
# - /opt/airun/offline-repo
# - $HOME/airun-offline-repo

# 수동으로 위치 지정 (install-offline.sh 편집):
OFFLINE_REPO_PATH="/custom/path/to/offline-repo"
```

### APT 패키지 의존성 오류
```bash
sudo apt-get install -f
# 또는
cd offline-repo/packages
sudo dpkg -i *.deb
sudo apt-get install -f
```

### Python Wheel 설치 실패
```bash
cd offline-repo/python-wheels
pip install --no-index --find-links=. --no-deps *.whl
```

---

## 디스크 공간 요구사항

| 구성요소 | 크기 | 설명 |
|---------|------|------|
| Debian 패키지 | 2-5 GB | 시스템 의존성 + 의존성 트리 |
| Python Wheels | 5-10 GB | PyTorch CUDA + 모든 Python 패키지 |
| AI 모델 | 2-3 GB | 임베딩 모델 3종 |
| Docker 이미지 | 400 MB | PostgreSQL + pgvector |
| Node.js | 50 MB | Node.js v22.18.0 바이너리 |
| **총계** | **10-20 GB** | 완전한 오프라인 패키지 |

---

## 관련 문서

- [오프라인 설치 전체 가이드](../docs/OFFLINE_INSTALLATION.md)
- [일반 설치 가이드](../docs/INSTALLATION.md)
- [문제 해결 가이드](../docs/TROUBLESHOOTING.md)

---

## 버전 정보

- 스크립트 버전: 2.1
- 대상 Ubuntu: 22.04 LTS, 24.04 LTS
- Python: 3.10, 3.12
- Node.js: 22.18.0
- PyTorch: 2.8+ (CUDA 12.9)

---

## 라이선스

AIRUN 라이선스를 따릅니다. 다운로드한 각 패키지는 해당 라이선스를 따릅니다.
