import test from 'node:test';
import assert from 'node:assert/strict';
import { extractPatientName } from '../builtin-tools.js';

const cases = [
  {
    name: 'handles quoted Korean name',
    input: `환자 "박영희" 건강 상태 알려줘`,
    expected: '박영희',
  },
  {
    name: 'matches Korean name before 환자 keyword',
    input: '김철수 환자의 혈압 수치를 알려주세요.',
    expected: '김철수',
  },
  {
    name: 'matches Korean name with 의 keyword',
    input: '신동욱의 혈압을 알려줘',
    expected: '신동욱',
  },
  {
    name: 'matches Japanese name with の and medical keyword',
    input: '田中さんの血圧を教えて',
    expected: '田中',
  },
  {
    name: 'matches Japanese name before 患者 keyword',
    input: '患者 山田太郎 の検査結果を確認して',
    expected: '山田太郎',
  },
  {
    name: 'matches Katakana name キムミンス',
    input: 'キムミンスの血圧を教えて',
    expected: 'キムミンス',
  },
  {
    name: 'matches Katakana name イジヨン',
    input: '患者 イジヨン の検査結果を確認して',
    expected: 'イジヨン',
  },
  {
    name: 'matches Katakana name パクソジュン',
    input: 'パクソジュンの健康診断結果を共有해줘',
    expected: 'パクソジュン',
  },
  {
    name: 'matches Katakana name チェスジン',
    input: 'チェスジンの血圧をチェック',
    expected: 'チェスジン',
  },
  {
    name: 'matches Katakana name チョンテウ',
    input: '患者 チョンテウ の状態を',
    expected: 'チョンテウ',
  },
  {
    name: 'matches Katakana name カンヘジン',
    input: 'カンヘジンの検診結果を 확인해줘',
    expected: 'カンヘジン',
  },
  {
    name: 'matches Katakana name ユンドンハ',
    input: 'ユンドンハの血糖値를 알려줘',
    expected: 'ユンドンハ',
  },
  {
    name: 'matches Katakana name イムソヨン',
    input: 'イムソヨンの血圧を教えて',
    expected: 'イムソヨン',
  },
  {
    name: 'matches Katakana name オジュンホ',
    input: '患者 オジュンホ の検査結果を 확인해줘',
    expected: 'オジュンホ',
  },
  {
    name: 'matches Katakana name ソンミレ',
    input: 'ソンミレの血圧 수치를 알려줘',
    expected: 'ソンミレ',
  },
  {
    name: 'matches Katakana name ハンジフン',
    input: 'ハンジフンの検査結果를 확인해줘',
    expected: 'ハンジフン',
  },
  {
    name: 'matches Katakana name チョウンア',
    input: '患者 チョウンア の状態を教えて',
    expected: 'チョウンア',
  },
  {
    name: 'matches Katakana name シンドンウク',
    input: 'シンドンウクの血圧を教えて',
    expected: 'シンドンウク',
  },
  {
    name: 'matches Katakana name ホンユジン',
    input: 'ホンユジンの検査結果를 공유해줘',
    expected: 'ホンユジン',
  },
  {
    name: 'matches Katakana name ペジュンソク',
    input: '患者 ペジュンソク の健康診断 결과를 알려줘',
    expected: 'ペジュンソク',
  },
  {
    name: 'returns null when no name detected',
    input: '환자 건강 상태를 알려줘.',
    expected: null,
  },
];

for (const { name, input, expected } of cases) {
  test(name, () => {
    const actual = extractPatientName(input);
    console.log("actual:", actual, "expected:", expected);
    assert.strictEqual(actual, expected);
  });
}
