# 하모나이즈 - 당신만의 소버린 AI 플랫폼

## 개요

**"하모나이즈, 당신만의 소버린 AI 플랫폼"**

하모나이즈는 조직이 단계적으로 AI 주권을 확보할 수 있도록 돕는 소버린 AI 오케스트레이션 플랫폼입니다. GPU 인프라 보유 수준에 따라 3가지 서비스 등급을 제공하여, 조직의 AI 도입 로드맵에 맞춰 자연스럽게 성장할 수 있도록 설계되었습니다.

### 🛤️ AI 도입 로드맵
```
📝 BASIC → ⚡ STANDARD → 🎯 PREMIUM
AI 경험 축적   자체 AI 구축   완전한 AI 주권
```

이 시스템은 환경 변수(.env 파일)를 통해 메뉴를 제어하여 서비스 구매자의 인프라 수준에 맞는 기능을 제공합니다.

## 인프라 기반 서비스 등급 구분

### 📝 BASIC 등급 - AI 경험 축적 단계
- **인프라 수준**: GPU 인프라 없음
- **AI 전략**: External LLM + RAG로 AI 활용 경험 축적
- **핵심 가치**: 최소 투자로 AI 도입 효과 검증
- **제공 기능**: 
  - 💬 대화하기 (Public LLM 활용)
  - 📄 문서(RAG) (내부 데이터 연계)
  - 🗂️ RAG 관리 (데이터 주권 확보)
  - 🎯 고객센터, 👥 사용자 관리, ⚙️ 설정, 📊 모니터링
- **성장 목표**: AI 사용 패턴 분석 → Standard 등급 이전 준비

### ⚡ STANDARD 등급 - 자체 AI 구축 단계
- **인프라 수준**: 추론용 GPU 인프라 보유
- **AI 전략**: Local LLM + 고도화된 AI 워크플로우 구축
- **핵심 가치**: 온프레미스 AI로 데이터 보안 + 성능 최적화
- **제공 기능**:
  - 💻 코드 생성 (개발 생산성 향상)
  - 🤖 자동화 (업무 프로세스 AI화)
  - 🧠 어시스턴트 (조직 특화 AI 도우미)
  - 📈 평가 (Local LLM 성능 모니터링)
  - 🗂️ RAG 관리 + 기본 관리 기능
- **성장 목표**: AI 내재화 완성 → Premium 등급 이전 준비

### 🎯 PREMIUM 등급 - 완전한 AI 주권 단계
- **인프라 수준**: 학습용 GPU 인프라 보유
- **AI 전략**: 자체 모델 개발 + 조직 특화 AI 솔루션 구축
- **핵심 가치**: 완전한 AI 자립 + 차별화된 AI 경쟁력 확보
- **추가 기능**:
  - 🧠 모델 관리 (파인튜닝, 커스텀 모델 개발)
  - 📈 고급 평가 (모델 성능 분석, A/B 테스트)
- **최종 목표**: 소버린 AI 플랫폼으로 AI 리더십 확보

## 파일 구조

```
workspaces/web/
├── .env.basic                    # Basic 등급 설정
├── .env.standard                 # Standard 등급 설정
├── .env.premium                  # Premium 등급 설정
├── .env.development.local        # 현재 활성 설정
├── .env.production              # 운영 환경 설정
├── switch-service-tier.sh       # 등급 전환 스크립트
└── src/components/Header.tsx    # 메뉴 제어 컴포넌트
```

## 환경 변수 설정

각 등급별 환경 변수는 다음과 같습니다:

### 서비스 등급 설정
```bash
NEXT_PUBLIC_SERVICE_TIER=basic|standard|premium
```

### 메뉴 제어 설정
```bash
# 일반 사용자 메뉴
NEXT_PUBLIC_ENABLE_CHAT=true|false
NEXT_PUBLIC_ENABLE_CODE=true|false
NEXT_PUBLIC_ENABLE_AGENT=true|false
NEXT_PUBLIC_ENABLE_ASSISTANT=true|false
NEXT_PUBLIC_ENABLE_DOCUMENT=true|false
NEXT_PUBLIC_ENABLE_SUPPORT=true|false

# 관리자 메뉴
NEXT_PUBLIC_ENABLE_RAG_ADMIN=true|false
NEXT_PUBLIC_ENABLE_MODEL_ADMIN=true|false
NEXT_PUBLIC_ENABLE_EVALUATION=true|false
NEXT_PUBLIC_ENABLE_USER_ADMIN=true|false
NEXT_PUBLIC_ENABLE_SETTINGS=true|false
NEXT_PUBLIC_ENABLE_MONITORING=true|false
```

## 사용법

### 1. 스크립트를 이용한 등급 전환

```bash
# 현재 상태 확인
./switch-service-tier.sh

# Basic 등급으로 전환
./switch-service-tier.sh basic

# Standard 등급으로 전환
./switch-service-tier.sh standard

# Premium 등급으로 전환
./switch-service-tier.sh premium
```

### 2. 수동 설정 변경

각 등급별 .env 파일을 직접 복사하여 사용할 수 있습니다:

```bash
# Basic 등급 적용
cp .env.basic .env.development.local

# Standard 등급 적용
cp .env.standard .env.development.local

# Premium 등급 적용
cp .env.premium .env.development.local
```

### 3. 개발 서버 재시작

환경 변수 변경 후 개발 서버를 재시작해야 합니다:

```bash
# 개발 서버 재시작
npm run dev
```

## 구현 상세

### Header.tsx 컴포넌트

`src/components/Header.tsx`에서 환경 변수를 읽어 메뉴를 동적으로 제어합니다:

```typescript
// 환경 변수 기반 메뉴 제어
const getMenuVisibility = () => {
  return {
    chat: process.env.NEXT_PUBLIC_ENABLE_CHAT === 'true',
    code: process.env.NEXT_PUBLIC_ENABLE_CODE === 'true',
    // ... 기타 메뉴 설정
  };
};
```

### 서비스 등급 표시

헤더에 현재 서비스 등급이 시각적으로 표시됩니다:
- **BASIC**: 회색 배경
- **STANDARD**: 파란색 배경
- **PREMIUM**: 보라색-핑크 그라데이션 배경

## 배포 환경 설정

운영 환경에서는 다음과 같이 설정합니다:

1. **Docker 환경 변수 설정**:
```bash
# docker-compose.yml 또는 환경 변수로 설정
NEXT_PUBLIC_SERVICE_TIER=basic
NEXT_PUBLIC_ENABLE_CHAT=true
NEXT_PUBLIC_ENABLE_CODE=false
# ... 기타 설정
```

2. **서버 환경 변수 설정**:
```bash
# .env.production 파일 또는 시스템 환경 변수
export NEXT_PUBLIC_SERVICE_TIER=standard
export NEXT_PUBLIC_ENABLE_CHAT=true
# ... 기타 설정
```

## 주의사항

1. **환경 변수 변경 후 서버 재시작 필요**: Next.js는 빌드 시점에 환경 변수를 읽으므로 변경 후 재시작이 필요합니다.

2. **NEXT_PUBLIC_ 접두사**: 클라이언트 사이드에서 접근할 수 있는 환경 변수는 `NEXT_PUBLIC_` 접두사가 필요합니다.

3. **백업 자동 생성**: 스크립트 사용 시 기존 설정이 자동으로 백업됩니다.

4. **사용자 역할과 독립적**: 이 시스템은 사용자 역할(admin, manager, user)과 독립적으로 작동합니다.

## 트러블슈팅

### 메뉴가 변경되지 않는 경우
1. 개발 서버 재시작 확인
2. 환경 변수 설정 확인
3. 브라우저 캐시 삭제

### 환경 변수가 적용되지 않는 경우
1. `NEXT_PUBLIC_` 접두사 확인
2. `.env.development.local` 파일 존재 확인
3. 환경 변수 값이 문자열 'true'/'false' 확인

## 문의

서비스 등급 관리 시스템에 대한 문의사항이나 개선사항이 있으시면 개발팀에 연락해주세요. 