import requests
import json
import time
from difflib import SequenceMatcher
import os

# OLLAMA_URL = "http://localhost:11434/api/generate"  # 필요시 프록시 주소로 변경

OLLAMA_URL = "https://profound-balanced-mammoth.ngrok-free.app/api/generate"

MODELS = [
    "hamonize:latest",
    # "airun-think:latest", 
    # "airun-vision:latest",
    # "deepseek-r1:latest",
    "devstral:latest",
    "gemma3:12b",
    # "gemma3:27b",
    "hyperclova-1.5b:latest",
    "mistral-small3.1:latest",
    "qwen3:14b",
]
QUESTIONS = [
    {"category": "math", "question": "2+2는?", "answer": "4"},
    {"category": "writing", "question": "다음 문장을 영어로 번역: 나는 집에 간다.", "answer": "I go home."},
    {"category": "coding", "question": "다음 코드의 출력은? print(1+1)", "answer": "2"},
    {"category": "reasoning", "question": '"고양이"와 "개"의 공통점은?', "answer": "동물"},
    {"category": "grammar", "question": '"나는 학교에 갑니다." 문법이 올바른가?', "answer": "예"},
]

SAVE_PATH = "ollama_eval_results.json"

# 기존 결과 불러오기
if os.path.exists(SAVE_PATH):
    with open(SAVE_PATH, "r", encoding="utf-8") as f:
        results = json.load(f)
else:
    results = {}

def similar(a, b):
    return SequenceMatcher(None, a, b).ratio()

for model in MODELS:
    if model not in results:
        results[model] = {}
    for q in QUESTIONS:
        if q["category"] in results[model]:
            continue  # 이미 평가된 항목은 건너뜀
        payload = {
            "model": model,
            "prompt": q["question"],
            "stream": False
        }
        try:
            resp = requests.post(OLLAMA_URL, json=payload, timeout=60)
            if resp.status_code == 200:
                data = resp.json()
                answer = data.get("response", "").strip()
                # 부분 일치 또는 유사도 기준
                if q["answer"] in answer or similar(answer, q["answer"]) > 0.7:
                    score = 10
                else:
                    score = 0
                results[model][q["category"]] = {
                    "question": q["question"],
                    "model_answer": answer,
                    "score": score
                }
                print(f"[{model}][{q['category']}] 답변: {answer} (점수: {score})")
            else:
                print(f"[{model}][{q['category']}] 오류: {resp.status_code} {resp.text}")
                results[model][q["category"]] = {
                    "question": q["question"],
                    "model_answer": "",
                    "score": 0,
                    "error": resp.text
                }
        except Exception as e:
            print(f"[{model}][{q['category']}] 예외: {e}")
            results[model][q["category"]] = {
                "question": q["question"],
                "model_answer": "",
                "score": 0,
                "error": str(e)
            }
        time.sleep(1)  # 과부하 방지
        # 평가 후 즉시 저장
        with open(SAVE_PATH, "w", encoding="utf-8") as f:
            json.dump(results, f, ensure_ascii=False, indent=2)

# 결과를 파일로 저장
with open("ollama_eval_results.json", "w", encoding="utf-8") as f:
    json.dump(results, f, ensure_ascii=False, indent=2)

print("\n전체 결과가 ollama_eval_results.json 파일에 저장되었습니다.")
