-- Formbuilder CASCADE Delete Constraints Migration
-- This script ensures proper CASCADE delete behavior for formbuilder tables

-- ai_form_responses 테이블이 존재하는지 확인하고 CASCADE 제약조건 추가
-- 기존 foreign key 제약조건을 삭제하고 CASCADE 옵션과 함께 재생성

DO $$
BEGIN
    -- ai_form_responses 테이블의 form_id foreign key 제약조건 확인 및 수정
    IF EXISTS (
        SELECT 1 FROM information_schema.table_constraints
        WHERE table_name = 'ai_form_responses'
        AND constraint_type = 'FOREIGN KEY'
        AND constraint_name LIKE '%form_id%'
    ) THEN
        -- 기존 제약조건 이름 찾기
        DECLARE
            constraint_name_var VARCHAR;
        BEGIN
            SELECT constraint_name INTO constraint_name_var
            FROM information_schema.table_constraints
            WHERE table_name = 'ai_form_responses'
            AND constraint_type = 'FOREIGN KEY'
            AND constraint_name LIKE '%form_id%'
            LIMIT 1;

            -- 기존 제약조건 삭제
            EXECUTE format('ALTER TABLE ai_form_responses DROP CONSTRAINT IF EXISTS %I', constraint_name_var);
        END;
    END IF;

    -- CASCADE DELETE 옵션과 함께 foreign key 제약조건 추가
    ALTER TABLE ai_form_responses
    ADD CONSTRAINT ai_form_responses_form_id_fkey
    FOREIGN KEY (form_id)
    REFERENCES ai_forms(id)
    ON DELETE CASCADE;

    RAISE NOTICE 'CASCADE delete constraint added to ai_form_responses.form_id';

EXCEPTION
    WHEN duplicate_object THEN
        RAISE NOTICE 'CASCADE constraint already exists';
    WHEN OTHERS THEN
        RAISE NOTICE 'Error adding CASCADE constraint: %', SQLERRM;
END $$;

-- ai_form_response_attachments 테이블의 CASCADE 제약조건도 확인
DO $$
BEGIN
    -- response_id foreign key 제약조건 확인 및 수정
    IF EXISTS (
        SELECT 1 FROM information_schema.table_constraints
        WHERE table_name = 'ai_form_response_attachments'
        AND constraint_type = 'FOREIGN KEY'
        AND constraint_name LIKE '%response_id%'
    ) THEN
        DECLARE
            constraint_name_var VARCHAR;
        BEGIN
            SELECT constraint_name INTO constraint_name_var
            FROM information_schema.table_constraints
            WHERE table_name = 'ai_form_response_attachments'
            AND constraint_type = 'FOREIGN KEY'
            AND constraint_name LIKE '%response_id%'
            LIMIT 1;

            -- 기존 제약조건 삭제
            EXECUTE format('ALTER TABLE ai_form_response_attachments DROP CONSTRAINT IF EXISTS %I', constraint_name_var);
        END;
    END IF;

    -- CASCADE DELETE 옵션과 함께 foreign key 제약조건 추가
    ALTER TABLE ai_form_response_attachments
    ADD CONSTRAINT ai_form_response_attachments_response_id_fkey
    FOREIGN KEY (response_id)
    REFERENCES ai_form_responses(id)
    ON DELETE CASCADE;

    RAISE NOTICE 'CASCADE delete constraint added to ai_form_response_attachments.response_id';

EXCEPTION
    WHEN duplicate_object THEN
        RAISE NOTICE 'CASCADE constraint already exists';
    WHEN OTHERS THEN
        RAISE NOTICE 'Error adding CASCADE constraint: %', SQLERRM;
END $$;
