import { NextRequest, NextResponse } from 'next/server';
import { getLLMFinetuneServerUrl } from '@/config/serverConfig';

const LLM_FINETUNE_BASE_URL = getLLMFinetuneServerUrl();

export async function GET(request: NextRequest) {
  try {
    const response = await fetch(`${LLM_FINETUNE_BASE_URL}/training`, {
      method: 'GET',
      headers: {
        'Content-Type': 'application/json',
      },
    });

    const data = await response.json();
    return NextResponse.json(data);
  } catch (error) {
    console.error('Training jobs fetch error:', error);
    return NextResponse.json(
      { success: false, error: 'Failed to fetch training jobs' },
      { status: 500 }
    );
  }
}

export async function POST(request: NextRequest) {
  try {
    const body = await request.json();
    
    const response = await fetch(`${LLM_FINETUNE_BASE_URL}/training`, {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
      },
      body: JSON.stringify(body),
    });

    const data = await response.json();
    return NextResponse.json(data);
  } catch (error) {
    console.error('Training start error:', error);
    return NextResponse.json(
      { success: false, error: 'Failed to start training' },
      { status: 500 }
    );
  }
}