import { NextResponse } from 'next/server';
import fs from 'fs';
import path from 'path';

export async function GET(req: Request) {
  const url = new URL(req.url!);
  const lines = parseInt(url.searchParams.get('lines') || '100', 10);
  const logPath = path.join(process.env.HOME || process.env.USERPROFILE || '', '.airun/logs/airun-rag.log');
  try {
    const data = fs.readFileSync(logPath, 'utf8');
    const logLines = data.trim().split('\n').slice(-lines);
    return NextResponse.json({ success: true, logs: logLines });
  } catch (e) {
    return NextResponse.json({ success: false, error: '로그 파일을 읽을 수 없습니다.' }, { status: 500 });
  }
} 