'use client';

import { useAuth } from '@/hooks/useAuth';
import ClientOnly from '@/components/ClientOnly';

export default function PrivacyPage() {
  const { isInitialized } = useAuth();

  if (!isInitialized) {
    return (
      <div className="flex items-center justify-center min-h-screen">
        <div className="text-center">
          <div 
            className="animate-spin rounded-full h-8 w-8 mx-auto mb-4"
            style={{ 
              border: '2px solid #e5e7eb', 
              borderBottomColor: '#ea580c' 
            }}
          ></div>
          <p className="text-gray-600 dark:text-gray-400">로딩 중...</p>
        </div>
      </div>
    );
  }

  return (
    <ClientOnly fallback={
      <div className="flex items-center justify-center min-h-screen">
        <div className="text-center">
          <div 
            className="animate-spin rounded-full h-8 w-8 mx-auto mb-4"
            style={{ 
              border: '2px solid #e5e7eb', 
              borderBottomColor: '#ea580c' 
            }}
          ></div>
          <p className="text-gray-600 dark:text-gray-400">로딩 중...</p>
        </div>
      </div>
    }>
      <div className="bg-white dark:bg-gray-900">
        <div className="max-w-4xl mx-auto px-4 py-8">
          <div className="bg-white dark:bg-gray-900 rounded-lg shadow-sm border border-gray-200 dark:border-gray-700 p-8">
            <h1 className="text-3xl font-bold text-gray-900 dark:text-white mb-8">
              개인정보처리방침
            </h1>
            
            <div className="prose prose-gray dark:prose-invert max-w-none">
              <div className="mb-6 p-4 bg-green-50 dark:bg-green-900/20 rounded-lg border border-green-200 dark:border-green-700">
                <p className="text-sm text-green-800 dark:text-green-200 mb-2">
                  <strong>시행일자:</strong> 2025년 1월 1일
                </p>
                <p className="text-sm text-green-800 dark:text-green-200">
                  <strong>최종 업데이트:</strong> 2025년 1월 1일
                </p>
              </div>

              <section className="mb-8">
                <h2 className="text-xl font-semibold text-gray-900 dark:text-white mb-4">1. 개인정보의 처리목적</h2>
                <p className="text-gray-700 dark:text-gray-300 mb-4">
                  (주)인베슘(이하 "회사")은 다음의 목적을 위하여 개인정보를 처리합니다. 처리하고 있는 개인정보는 다음의 목적 이외의 용도로는 이용되지 않으며, 이용 목적이 변경되는 경우에는 「개인정보 보호법」 제18조에 따라 별도의 동의를 받는 등 필요한 조치를 이행할 예정입니다.
                </p>
                <div className="ml-4 space-y-2">
                  <p className="text-gray-700 dark:text-gray-300">가. 회원 가입 및 관리</p>
                  <p className="text-gray-700 dark:text-gray-300">나. AI 서비스 제공</p>
                  <p className="text-gray-700 dark:text-gray-300">다. 고객 문의 및 민원 처리</p>
                  <p className="text-gray-700 dark:text-gray-300">라. 서비스 개선 및 신규 서비스 개발</p>
                  <p className="text-gray-700 dark:text-gray-300">마. 부정 이용 방지 및 보안</p>
                </div>
              </section>

              <section className="mb-8">
                <h2 className="text-xl font-semibold text-gray-900 dark:text-white mb-4">2. 개인정보의 처리 및 보유기간</h2>
                <div className="space-y-4">
                  <p className="text-gray-700 dark:text-gray-300">
                    회사는 법령에 따른 개인정보 보유·이용기간 또는 정보주체로부터 개인정보를 수집 시에 동의받은 개인정보 보유·이용기간 내에서 개인정보를 처리·보유합니다.
                  </p>
                  <div className="bg-gray-50 dark:bg-gray-800 p-4 rounded-lg">
                    <h3 className="font-semibold text-gray-900 dark:text-white mb-2">구체적인 개인정보 처리 및 보유기간</h3>
                    <div className="space-y-2 text-sm">
                      <p className="text-gray-700 dark:text-gray-300">• 회원 정보: 회원 탈퇴 시까지</p>
                      <p className="text-gray-700 dark:text-gray-300">• 서비스 이용 기록: 3년</p>
                      <p className="text-gray-700 dark:text-gray-300">• 결제 정보: 5년 (전자상거래법)</p>
                      <p className="text-gray-700 dark:text-gray-300">• 고객 문의 기록: 3년</p>
                    </div>
                  </div>
                </div>
              </section>

              <section className="mb-8">
                <h2 className="text-xl font-semibold text-gray-900 dark:text-white mb-4">3. 처리하는 개인정보의 항목</h2>
                <div className="space-y-4">
                  <div className="border border-gray-200 dark:border-gray-600 rounded-lg p-4">
                    <h3 className="font-semibold text-gray-900 dark:text-white mb-2">필수항목</h3>
                    <p className="text-gray-700 dark:text-gray-300">이메일, 비밀번호, 닉네임</p>
                  </div>
                  <div className="border border-gray-200 dark:border-gray-600 rounded-lg p-4">
                    <h3 className="font-semibold text-gray-900 dark:text-white mb-2">선택항목</h3>
                    <p className="text-gray-700 dark:text-gray-300">프로필 이미지, 전화번호</p>
                  </div>
                  <div className="border border-gray-200 dark:border-gray-600 rounded-lg p-4">
                    <h3 className="font-semibold text-gray-900 dark:text-white mb-2">자동 수집 항목</h3>
                    <p className="text-gray-700 dark:text-gray-300">IP주소, 쿠키, 서비스 이용 기록, 접속 로그, 접속 기기 정보</p>
                  </div>
                </div>
              </section>

              <section className="mb-8">
                <h2 className="text-xl font-semibold text-gray-900 dark:text-white mb-4">4. 개인정보의 제3자 제공</h2>
                <p className="text-gray-700 dark:text-gray-300 mb-4">
                  회사는 정보주체의 개인정보를 개인정보의 처리목적에서 명시한 범위 내에서만 처리하며, 정보주체의 동의, 법률의 특별한 규정 등 「개인정보 보호법」 제17조에 해당하는 경우에만 개인정보를 제3자에게 제공합니다.
                </p>
                <div className="bg-yellow-50 dark:bg-yellow-900/20 p-4 rounded-lg border border-yellow-200 dark:border-yellow-700">
                  <p className="text-yellow-800 dark:text-yellow-200 text-sm">
                    <strong>현재 회사는 개인정보를 제3자에게 제공하고 있지 않습니다.</strong> 향후 제3자 제공이 필요한 경우 사전에 동의를 받겠습니다.
                  </p>
                </div>
              </section>

              <section className="mb-8">
                <h2 className="text-xl font-semibold text-gray-900 dark:text-white mb-4">5. 개인정보처리 위탁</h2>
                <p className="text-gray-700 dark:text-gray-300 mb-4">
                  회사는 원활한 개인정보 업무처리를 위하여 다음과 같이 개인정보 처리업무를 위탁하고 있습니다.
                </p>
                <div className="bg-gray-50 dark:bg-gray-800 p-4 rounded-lg">
                  <div className="space-y-2">
                    <p className="text-gray-700 dark:text-gray-300">
                      <strong>위탁받는 자:</strong> Amazon Web Services Korea LLC
                    </p>
                    <p className="text-gray-700 dark:text-gray-300">
                      <strong>위탁업무 내용:</strong> 클라우드 서버 및 데이터베이스 관리
                    </p>
                    <p className="text-gray-700 dark:text-gray-300">
                      <strong>위탁기간:</strong> 서비스 제공 기간
                    </p>
                  </div>
                </div>
              </section>

              <section className="mb-8">
                <h2 className="text-xl font-semibold text-gray-900 dark:text-white mb-4">6. 정보주체의 권리·의무 및 행사방법</h2>
                <div className="space-y-3">
                  <p className="text-gray-700 dark:text-gray-300">
                    정보주체는 회사에 대해 언제든지 다음 각 호의 개인정보 보호 관련 권리를 행사할 수 있습니다.
                  </p>
                  <div className="ml-4 space-y-2">
                    <p className="text-gray-700 dark:text-gray-300">1. 개인정보 처리현황 통지 요구</p>
                    <p className="text-gray-700 dark:text-gray-300">2. 개인정보 열람 요구</p>
                    <p className="text-gray-700 dark:text-gray-300">3. 개인정보 정정·삭제 요구</p>
                    <p className="text-gray-700 dark:text-gray-300">4. 개인정보 처리정지 요구</p>
                  </div>
                  <p className="text-gray-700 dark:text-gray-300">
                    상기 권리 행사는 회사에 대해 서면, 전화, 전자우편, 모사전송(FAX) 등을 통하여 하실 수 있으며 회사는 이에 대해 지체없이 조치하겠습니다.
                  </p>
                </div>
              </section>

              <section className="mb-8">
                <h2 className="text-xl font-semibold text-gray-900 dark:text-white mb-4">7. 개인정보의 안전성 확보조치</h2>
                <p className="text-gray-700 dark:text-gray-300 mb-4">
                  회사는 개인정보의 안전성 확보를 위해 다음과 같은 조치를 취하고 있습니다.
                </p>
                <div className="grid md:grid-cols-2 gap-4">
                  <div className="border border-gray-200 dark:border-gray-600 rounded-lg p-4">
                    <h3 className="font-semibold text-gray-900 dark:text-white mb-2">기술적 조치</h3>
                    <ul className="text-sm text-gray-700 dark:text-gray-300 space-y-1">
                      <li>• 개인정보 암호화</li>
                      <li>• 접근통제시스템 설치</li>
                      <li>• 보안프로그램 설치</li>
                      <li>• 접속기록 보관</li>
                    </ul>
                  </div>
                  <div className="border border-gray-200 dark:border-gray-600 rounded-lg p-4">
                    <h3 className="font-semibold text-gray-900 dark:text-white mb-2">관리적 조치</h3>
                    <ul className="text-sm text-gray-700 dark:text-gray-300 space-y-1">
                      <li>• 내부관리계획 수립</li>
                      <li>• 정기적 직원 교육</li>
                      <li>• 개인정보 취급자 최소화</li>
                      <li>• 개인정보보호책임자 지정</li>
                    </ul>
                  </div>
                </div>
              </section>

              <section className="mb-8">
                <h2 className="text-xl font-semibold text-gray-900 dark:text-white mb-4">8. 개인정보보호책임자</h2>
                <div className="bg-blue-50 dark:bg-blue-900/20 p-4 rounded-lg border border-blue-200 dark:border-blue-700">
                  <div className="space-y-2">
                    <p className="text-blue-800 dark:text-blue-200">
                      <strong>개인정보보호책임자:</strong> 김형채
                    </p>
                    <p className="text-blue-800 dark:text-blue-200">
                      <strong>연락처:</strong> 02-2039-3977
                    </p>
                    <p className="text-blue-800 dark:text-blue-200">
                      <strong>이메일:</strong> sales@invesume.com
                    </p>
                  </div>
                </div>
                <p className="text-gray-700 dark:text-gray-300 mt-4">
                  정보주체께서는 회사의 서비스를 이용하시면서 발생한 모든 개인정보 보호 관련 문의, 불만처리, 피해구제 등에 관한 사항을 개인정보보호책임자에게 문의하실 수 있습니다.
                </p>
              </section>

              <section className="mb-8">
                <h2 className="text-xl font-semibold text-gray-900 dark:text-white mb-4">9. 권익침해 구제방법</h2>
                <p className="text-gray-700 dark:text-gray-300 mb-4">
                  정보주체는 아래의 기관에 대해 개인정보 침해신고를 할 수 있습니다.
                </p>
                <div className="grid md:grid-cols-3 gap-4 text-sm">
                  <div className="border border-gray-200 dark:border-gray-600 rounded-lg p-3">
                    <h3 className="font-semibold text-gray-900 dark:text-white mb-2">개인정보보호위원회</h3>
                    <p className="text-gray-700 dark:text-gray-300">privacy.go.kr</p>
                    <p className="text-gray-700 dark:text-gray-300">국번없이 182</p>
                  </div>
                  <div className="border border-gray-200 dark:border-gray-600 rounded-lg p-3">
                    <h3 className="font-semibold text-gray-900 dark:text-white mb-2">정보보호 마크 인증위원회</h3>
                    <p className="text-gray-700 dark:text-gray-300">privacy.go.kr</p>
                    <p className="text-gray-700 dark:text-gray-300">02-2100-2820</p>
                  </div>
                  <div className="border border-gray-200 dark:border-gray-600 rounded-lg p-3">
                    <h3 className="font-semibold text-gray-900 dark:text-white mb-2">대검찰청 사이버범죄수사단</h3>
                    <p className="text-gray-700 dark:text-gray-300">spo.go.kr</p>
                    <p className="text-gray-700 dark:text-gray-300">국번없이 1301</p>
                  </div>
                </div>
              </section>

              <section className="mb-8">
                <h2 className="text-xl font-semibold text-gray-900 dark:text-white mb-4">10. 개인정보처리방침 변경</h2>
                <p className="text-gray-700 dark:text-gray-300">
                  이 개인정보처리방침은 시행일자부터 적용되며, 법령 및 방침에 따른 변경내용의 추가, 삭제 및 정정이 있는 경우에는 변경사항의 시행 7일 전부터 공지사항을 통하여 고지할 것입니다.
                </p>
              </section>

              <div className="mt-12 pt-8 border-t border-gray-200 dark:border-gray-700">
                <p className="text-sm text-gray-500 dark:text-gray-400 text-center">
                  본 개인정보처리방침은 2025년 1월 1일부터 적용됩니다.
                </p>
              </div>
            </div>
          </div>
        </div>
      </div>
    </ClientOnly>
  );
} 