import React from 'react';
import ReactMarkdown from 'react-markdown';
import remarkGfm from 'remark-gfm';
import remarkBreaks from 'remark-breaks';
import remarkBoldBox from '@/utils/remarkBoldBox';

interface ChunkMarkdownRendererProps {
  content: string;
  className?: string;
}

export const ChunkMarkdownRenderer: React.FC<ChunkMarkdownRendererProps> = ({ content, className = '' }) => {
  // 표 블록 감지: |로 시작하는 연속된 줄은 <pre>로, 나머지는 일반 텍스트 버퍼에 저장
  const lines: string[] = content.split('\n');
  const result: React.ReactNode[] = [];
  let tableBuffer: string[] = [];
  let textBuffer: string[] = [];
  const flushTable = () => {
    if (tableBuffer.length > 0) {
      result.push(
        <pre
          className="font-mono font-bold bg-transparent text-[13px] leading-6 whitespace-pre break-words my-2"
          style={{ fontFamily: 'D2Coding, Fira Mono, Menlo, Monaco, Consolas, monospace' }}
          key={result.length}
        >
          {tableBuffer.join('\n')}
        </pre>
      );
      tableBuffer = [];
    }
  };
  const flushText = () => {
    if (textBuffer.length > 0) {
      result.push(
        <pre
          className="my-1 bg-transparent"
          style={{ fontFamily: 'inherit', fontWeight: 'normal', fontStyle: 'normal', background: 'none', boxShadow: 'none', border: 'none', padding: 0, margin: 0, whiteSpace: 'pre-wrap' }}
          key={result.length}
        >
          {textBuffer.join('\n')}
        </pre>
      );
      textBuffer = [];
    }
  };
  lines.forEach((line: string) => {
    if (line.trim().startsWith('|') && (line.match(/\|/g) || []).length >= 2) {
      flushText();
      tableBuffer.push(line);
    } else {
      flushTable();
      textBuffer.push(line);
    }
  });
  flushTable();
  flushText();

  return <div className={`chunk-preview-markdown ${className}`}>{result}</div>;
}; 