'use client';

import { usePathname } from 'next/navigation';
import Header from '@/components/Header';

export default function ConditionalLayout({ children }: { children: React.ReactNode }) {
  const pathname = usePathname();
  const isFormPage = pathname?.startsWith('/form/');

  if (isFormPage) {
    // 폼 페이지: 헤더 없이 전체 화면 사용
    return <>{children}</>;
  }

  // 일반 페이지: 헤더 포함
  return (
    <div className="h-screen flex flex-col" style={{ backgroundColor: 'var(--body-bg)' }}>
      <Header />
      <main className="flex-1 overflow-auto min-h-0" style={{ backgroundColor: 'var(--body-bg)' }}>
        {children}
      </main>
    </div>
  );
}
