'use client';

import Link from 'next/link';
import { usePathname } from 'next/navigation';
import { useState, useEffect } from 'react';

interface SubMenuNavProps {
  section: string;
}

export default function SubMenuNav({ section }: SubMenuNavProps) {
  const pathname = usePathname();
  const mainSection = pathname.split('/')[1] || 'home';
  const [activeItem, setActiveItem] = useState(pathname);
  const [isMobile, setIsMobile] = useState(false);

  // 화면 크기 감지
  useEffect(() => {
    const handleResize = () => {
      setIsMobile(window.innerWidth < 640);
    };
    
    handleResize(); // 초기 실행
    window.addEventListener('resize', handleResize);
    
    return () => {
      window.removeEventListener('resize', handleResize);
    };
  }, []);

  // 경로에 따른 서브메뉴 아이템 설정
  const menuItems = {
    home: [],
    chat: [
      { name: '새 대화', path: '/chat/new' },
      { name: '대화 목록', path: '/chat/list' },
    ],
    // 다른 섹션들은 단일 페이지로 구성되어 있으므로 서브메뉴 제거
    code: [],
    document: [],
    automation: [],
    settings: [],
    monitoring: [],
    profile: [],
  };

  // 현재 섹션에 해당하는 서브메뉴 아이템 가져오기
  const currentItems = menuItems[mainSection as keyof typeof menuItems] || [];

  // 홈 화면이거나 메뉴 아이템이 없으면 서브메뉴 숨기기
  if (mainSection === 'home' || currentItems.length === 0) {
    return null;
  }

  // 대화하기는 이제 단일 페이지이므로 서브메뉴 없음
  if (section === 'chat') {
    return null;
  }

  // 다른 섹션들도 단일 페이지이므로 서브메뉴 없음
  return null;
} 