import type { NodeData } from '@/types/flowai';

export interface NodeConfigProps {
  node: NodeData;
  onNodeUpdate: (nodeId: string, updates: Partial<NodeData>) => void;
}

export interface Provider {
  key: string;
  name: string;
  requiresApiKey: boolean;
  apiKeyConfigured: boolean;
  isDynamic: boolean;
  isAvailable: boolean;
  models: Model[];
}

export interface Model {
  id: string;
  name: string;
  description?: string;
}