'use client';

import { FC } from 'react';

interface MessageProps {
  message: {
    id: string;
    content: string;
    role: 'user' | 'assistant';
    createdAt: string;
  };
}

const Message: FC<MessageProps> = ({ message }) => {
  const { content, role, createdAt } = message;
  const isUser = role === 'user';
  
  // 시간 포맷팅
  const formatTime = (dateString: string) => {
    const date = new Date(dateString);
    return date.toLocaleTimeString([], { hour: '2-digit', minute: '2-digit' });
  };

  return (
    <div className={`py-3 px-4 ${isUser ? '' : 'bg-gray-50 dark:bg-gray-800/50'}`}>
      <div className="max-w-4xl mx-auto flex">
        {/* 사용자 아바타 또는 AI 아바타 */}
        <div className="flex-shrink-0 mr-3">
          <div
            className={`flex items-center justify-center rounded-full w-8 h-8 text-sm ${
              isUser
                ? 'bg-blue-700 dark:bg-blue-600 text-white shadow-md'
                : 'bg-purple-600 text-white'
            }`}
          >
            {isUser ? (
              <span>U</span>
            ) : (
              <span>AI</span>
            )}
          </div>
        </div>
        
        {/* 메시지 내용 */}
        <div className="flex-1 min-w-0">
          <div className="flex items-baseline mb-1">
            <span className="font-medium text-sm mr-2">
              {isUser ? '사용자' : '어시스턴트'}
            </span>
            <span className="text-xs text-gray-500 dark:text-gray-400">
              {formatTime(createdAt)}
            </span>
          </div>
          
          <div className={`rounded-lg p-3 inline-block max-w-[85%] ${
            isUser 
              ? 'bg-blue-700 dark:bg-blue-600 text-white rounded-tr-none shadow-lg border border-blue-800 dark:border-blue-500' 
              : 'bg-white dark:bg-gray-700 text-gray-800 dark:text-gray-200 border border-gray-200 dark:border-gray-600 rounded-tl-none'
          }`}>
            <p className="whitespace-pre-wrap break-words text-sm">{content}</p>
          </div>
        </div>
      </div>
    </div>
  );
};

export default Message; 