// 이슈 상태 뱃지
export function StatusBadge({ status }: { status: 'open' | 'in_progress' | 'resolved' | 'closed' }) {
  const styles = {
    open: 'bg-yellow-100 text-yellow-800 dark:bg-yellow-900 dark:text-yellow-300',
    in_progress: 'bg-blue-100 text-blue-800 dark:bg-blue-900 dark:text-blue-300',
    resolved: 'bg-green-100 text-green-800 dark:bg-green-900 dark:text-green-300',
    closed: 'bg-gray-100 text-gray-800 dark:bg-gray-900 dark:text-gray-300'
  };
  const labels = {
    open: '접수',
    in_progress: '처리중',
    resolved: '해결됨',
    closed: '종료'
  };
  return (
    <span className={`px-2 py-1 text-xs font-medium rounded ${styles[status]}`}>
      {labels[status]}
    </span>
  );
}

// 우선순위 뱃지
export function PriorityBadge({ priority }: { priority: 'low' | 'medium' | 'high' | 'urgent' }) {
  const styles = {
    low: 'bg-gray-100 text-gray-800 dark:bg-gray-900 dark:text-gray-300',
    medium: 'bg-blue-100 text-blue-800 dark:bg-blue-900 dark:text-blue-300',
    high: 'bg-orange-100 text-orange-800 dark:bg-orange-900 dark:text-orange-300',
    urgent: 'bg-red-100 text-red-800 dark:bg-red-900 dark:text-red-300'
  };
  const labels = {
    low: '낮음',
    medium: '보통',
    high: '높음',
    urgent: '긴급'
  };
  return (
    <span className={`px-2 py-1 text-xs font-medium rounded ${styles[priority]}`}>
      {labels[priority]}
    </span>
  );
} 