export interface Message {
  role: "user" | "assistant";
  content: string;
}

export interface Reply {
  id: string;
  content: string;
  authorName: string;
  authorRole: string;
  createdAt: string;
}

export interface SupportIssue {
  id: string;
  title: string;
  content: string;
  status: string;
  createdAt: string;
  author: {
    name: string;
    role: string;
  };
  images?: string[];
  replies?: Reply[];
}

export interface BackgroundJob {
  id: string;
  type: 'file_upload' | 'ticket_sync';
  status: 'pending' | 'running' | 'completed' | 'failed';
  progress: number; // 0-100
  message?: string;
  filename?: string; // for file uploads
  createdAt: string;
  updatedAt: string;
  userId: string;
  error?: string;
}

export interface BackgroundJobStatus {
  jobs: BackgroundJob[];
  activeJobs: number;
  completedJobs: number;
  failedJobs: number;
} 