# Chandra OCR 테스트 가이드

## 테스트 완료 사항

### 1. 환경 설정 ✅
- GitHub 프로젝트 클론 완료
- Python 가상환경 및 패키지 설치 완료
- Chandra 모델 다운로드 완료 (datalab-to/chandra)

### 2. 모델 테스트 ✅
- PDF 파일: `/data/docs/리모델링신청서.pdf`
- HuggingFace 방식으로 성공적으로 처리됨
- 출력 파일 위치: `/data/chandra/output/리모델링신청서/`

### 3. 생성된 결과 파일
```
output/리모델링신청서/
├── 리모델링신청서.md              # Markdown 형식
├── 리모델링신청서.html            # HTML 형식
├── 리모델링신청서_metadata.json   # 메타데이터 (페이지 정보, 토큰 수 등)
└── 리모델링신청서_structured.json # 구조화된 JSON (커스텀 스크립트로 생성)
```

## 사용 방법

### 1. CLI 사용 (명령줄)

#### HuggingFace 방식 (권장 - 테스트 완료)
```bash
cd /data/chandra
source .venv/bin/activate
export PATH="$HOME/.local/bin:$PATH"

# 단일 파일 처리
chandra /path/to/file.pdf ./output --method hf

# 디렉토리 전체 처리
chandra /path/to/directory ./output --method hf
```

#### vLLM 방식 (서버 필요)
```bash
# 1. vLLM 서버 시작 (백그라운드)
chandra_vllm &

# 2. 서버가 준비되면 파일 처리
chandra /path/to/file.pdf ./output --method vllm
```

### 2. Python API 사용

#### 기본 사용법
```python
from chandra.model.hf import load_model, generate_hf
from chandra.model.schema import BatchInputItem
from PIL import Image

# 모델 로드
model = load_model()

# 이미지 로드
image = Image.open("document.png")

# 처리
batch = [BatchInputItem(image=image, prompt_type="default")]
results = generate_hf(batch, model)

print(results[0].raw)  # Markdown 출력
```

#### JSON 변환 스크립트 사용
```bash
# HTML을 구조화된 JSON으로 변환
python test_json_extraction.py
```

### 3. 웹 애플리케이션 사용

#### Flask 웹 데모 실행
```bash
cd /data/chandra
source .venv/bin/activate
export PATH="$HOME/.local/bin:$PATH"

python web_demo.py
```

브라우저에서 `http://localhost:5000` 접속 후:
1. PDF/이미지 파일 업로드
2. 분석 시작 버튼 클릭
3. 결과를 JSON, HTML, Markdown 형태로 확인

#### Streamlit 앱 (공식)
```bash
chandra_app
```

## 테스트 결과 요약

### 문서 인식 정확도
- ✅ 한글 텍스트 정확히 인식
- ✅ 복잡한 테이블 구조 정확히 재현
- ✅ 체크박스 인식 (`<input type="checkbox"/>`)
- ✅ 상첨자/서식 유지 (m²)
- ✅ 리스트 구조 정확히 추출

### 출력 형식
1. **Markdown**: 텍스트 편집 가능한 형식
2. **HTML**: 웹에서 바로 렌더링 가능
3. **JSON**: 구조화된 데이터로 프로그래밍 처리 가능
   - 제목
   - 테이블 (헤더, 행, 셀 병합 정보 포함)
   - 단락
   - 리스트

### 성능
- 1페이지 PDF 처리 시간: 약 2-3분 (첫 실행 시 모델 다운로드 포함)
- 이후 처리: 페이지당 10-30초
- 메모리 사용: 약 10-15GB VRAM

## 추가 기능

### CLI 옵션
```bash
chandra --help

옵션:
  --method [hf|vllm]              # 추론 방식 (기본: vllm)
  --page-range TEXT               # PDF 페이지 범위 (예: "1-5,7,9-12")
  --max-output-tokens INTEGER     # 페이지당 최대 토큰 수
  --max-workers INTEGER           # vLLM 병렬 워커 수
  --include-images/--no-images    # 이미지 추출 여부 (기본: 포함)
  --batch-size INTEGER            # 배치 크기 (기본: 1)
```

### 환경 변수 설정 (local.env)
```bash
# 모델 설정
MODEL_CHECKPOINT=datalab-to/chandra
MAX_OUTPUT_TOKENS=12384

# vLLM 설정
VLLM_API_BASE=http://localhost:8000/v1
VLLM_MODEL_NAME=chandra
VLLM_GPUS=0
```

## 참고 사항

### 지원 파일 형식
- PDF (.pdf)
- 이미지 (.png, .jpg, .jpeg)

### 지원 언어
- 40개 이상 언어 (한글 포함)

### 모델 정보
- 모델: Qwen3-VL 기반
- 체크포인트: 4개 샤드
- 라이선스: Apache 2.0 (코드), 수정된 OpenRAIL-M (모델)

## 다음 단계

1. **성능 최적화**: vLLM 서버 사용으로 처리 속도 향상
2. **배치 처리**: 여러 파일 동시 처리
3. **커스터마이징**: 특정 문서 형식에 맞는 JSON 스키마 정의
4. **API 통합**: Flask/FastAPI로 REST API 구축

## 문제 해결

### 메모리 부족
- `--gpu-memory-utilization` 값 조정
- 배치 크기 줄이기

### 처리 속도 개선
- vLLM 서버 사용
- GPU 수 늘리기 (`VLLM_GPUS=0,1`)

### 권한 오류
- 출력 디렉토리 권한 확인
- Docker 그룹 확인 (`groups` 명령)

## 연락처
- GitHub: https://github.com/datalab-to/chandra
- 호스티드 API: https://www.datalab.to/
- Playground: https://www.datalab.to/playground
