ALLOWED_TAGS = [
    "math",
    "br",
    "i",
    "b",
    "u",
    "del",
    "sup",
    "sub",
    "table",
    "tr",
    "td",
    "p",
    "th",
    "div",
    "pre",
    "h1",
    "h2",
    "h3",
    "h4",
    "h5",
    "ul",
    "ol",
    "li",
    "input",
    "a",
    "span",
    "img",
    "hr",
    "tbody",
    "small",
    "caption",
    "strong",
    "thead",
    "big",
    "code",
]
ALLOWED_ATTRIBUTES = [
    "class",
    "colspan",
    "rowspan",
    "display",
    "checked",
    "type",
    "border",
    "value",
    "style",
    "href",
    "alt",
    "align",
]

PROMPT_ENDING = f"""
Only use these tags {ALLOWED_TAGS}, and these attributes {ALLOWED_ATTRIBUTES}.

Guidelines:
* Inline math: Surround math with <math>...</math> tags. Math expressions should be rendered in KaTeX-compatible LaTeX. Use display for block math.
* Tables: Use colspan and rowspan attributes to match table structure.
* Formatting: Maintain consistent formatting with the image, including spacing, indentation, subscripts/superscripts, and special characters.
* Images: CRITICAL - Provide CONCISE, one-line Korean descriptions (maximum 100 characters) for ALL images in the alt attribute. Never leave alt empty. Be specific but brief. Examples: "회의실에서 노트북을 사용하는 두 사람", "2023년 매출 증가 추이 그래프", "회사 로고". Do NOT use verbose multi-paragraph descriptions. Keep it simple and to the point.
* Forms: Mark checkboxes and radio buttons properly.
* Text: join lines together properly into paragraphs using <p>...</p> tags.  Use <br> tags for line breaks within paragraphs, but only when absolutely necessary to maintain meaning.
* Use the simplest possible HTML structure that accurately represents the content of the block.
* Make sure the text is accurate and easy for a human to read and interpret.  Reading order should be correct and natural.
""".strip()

OCR_LAYOUT_PROMPT = f"""
**이미지 설명 작성 필수 규칙**:
1. 모든 이미지는 **간결한 한 문장 설명** (최대 100자)
2. **한국어만 사용** (영어, 알파벳, 영문 약어 절대 금지)
3. **구체적이지만 간결하게** - 장황한 다단락 설명 금지
4. **빈 설명 절대 금지** - 모든 이미지에 반드시 설명 포함

예시 (좋은 간결한 설명):
- "회의실에서 노트북을 보는 두 사람"
- "2023년 매출 증가 추이 그래프"
- "데이터 분석 차트와 그래프"
- "회사 로고 이미지"

절대 금지 (나쁜 예):
- 빈 설명: alt=""
- 영어 사용: alt="Meeting Room"
- 장황한 설명: 여러 문장, 여러 단락으로 된 긴 설명
OCR this image to HTML, arranged as layout blocks.  Each layout block should be a div with the data-bbox attribute representing the bounding box of the block in [x0, y0, x1, y1] format.  Bboxes are normalized 0-1024. The data-label attribute is the label for the block.

Use the following labels:
- Caption
- Footnote
- Equation-Block
- List-Group
- Page-Header
- Page-Footer
- Image
- Section-Header
- Table
- Text
- Complex-Block
- Code-Block
- Form
- Table-Of-Contents
- Figure

{PROMPT_ENDING}
""".strip()

OCR_PROMPT = f"""
OCR this image to HTML.

{PROMPT_ENDING}
""".strip()

PROMPT_MAPPING = {
    "ocr_layout": OCR_LAYOUT_PROMPT,
    "ocr": OCR_PROMPT,
}
