#!/bin/bash
# Chandra OCR 서비스 설치 스크립트

set -e

echo "================================================"
echo "Chandra OCR 서비스 설치"
echo "================================================"
echo ""

# 색상 정의
GREEN='\033[0;32m'
YELLOW='\033[1;33m'
RED='\033[0;31m'
NC='\033[0m' # No Color

# 현재 디렉토리 확인
if [ ! -f "web_demo_subpath.py" ]; then
    echo -e "${RED}오류: /data/chandra 디렉토리에서 실행해주세요${NC}"
    exit 1
fi

echo -e "${YELLOW}1. 로그 디렉토리 생성${NC}"
sudo mkdir -p /var/log/chandra-ocr
sudo chown airun:airun /var/log/chandra-ocr
echo -e "${GREEN}✓ 완료${NC}"
echo ""

echo -e "${YELLOW}2. Systemd 서비스 파일 설치${NC}"
sudo cp chandra-ocr.service /etc/systemd/system/
sudo systemctl daemon-reload
echo -e "${GREEN}✓ 완료${NC}"
echo ""

echo -e "${YELLOW}3. Nginx 설정 안내${NC}"
echo "다음 내용을 /etc/nginx/sites-available/hamonize.conf 파일에 추가하세요:"
echo ""
echo -e "${YELLOW}----------------------------------------${NC}"
cat nginx_aiform.conf
echo -e "${YELLOW}----------------------------------------${NC}"
echo ""
read -p "Nginx 설정을 추가했습니까? (y/n) " -n 1 -r
echo
if [[ $REPLY =~ ^[Yy]$ ]]; then
    echo -e "${GREEN}✓ 확인${NC}"
else
    echo -e "${YELLOW}나중에 수동으로 추가해주세요${NC}"
    echo "설정 파일: /data/chandra/nginx_aiform.conf"
fi
echo ""

echo -e "${YELLOW}4. Nginx 설정 테스트${NC}"
if sudo nginx -t; then
    echo -e "${GREEN}✓ Nginx 설정 정상${NC}"
    read -p "Nginx를 reload 하시겠습니까? (y/n) " -n 1 -r
    echo
    if [[ $REPLY =~ ^[Yy]$ ]]; then
        sudo systemctl reload nginx
        echo -e "${GREEN}✓ Nginx reload 완료${NC}"
    fi
else
    echo -e "${RED}✗ Nginx 설정 오류. 설정을 확인해주세요${NC}"
fi
echo ""

echo -e "${YELLOW}5. Chandra OCR 서비스 시작${NC}"
read -p "서비스를 시작하시겠습니까? (y/n) " -n 1 -r
echo
if [[ $REPLY =~ ^[Yy]$ ]]; then
    sudo systemctl start chandra-ocr
    sleep 2
    sudo systemctl status chandra-ocr --no-pager
    echo ""
    echo -e "${GREEN}✓ 서비스 시작 완료${NC}"
else
    echo -e "${YELLOW}나중에 다음 명령으로 시작하세요:${NC}"
    echo "  sudo systemctl start chandra-ocr"
fi
echo ""

echo -e "${YELLOW}6. 부팅 시 자동 시작 설정${NC}"
read -p "부팅 시 자동으로 시작하시겠습니까? (y/n) " -n 1 -r
echo
if [[ $REPLY =~ ^[Yy]$ ]]; then
    sudo systemctl enable chandra-ocr
    echo -e "${GREEN}✓ 자동 시작 설정 완료${NC}"
fi
echo ""

echo "================================================"
echo -e "${GREEN}설치 완료!${NC}"
echo "================================================"
echo ""
echo "접속 URL:"
echo "  https://www.hamonize.com/aiform"
echo ""
echo "서비스 관리 명령어:"
echo "  sudo systemctl status chandra-ocr   # 상태 확인"
echo "  sudo systemctl restart chandra-ocr  # 재시작"
echo "  sudo systemctl stop chandra-ocr     # 중지"
echo "  sudo journalctl -u chandra-ocr -f   # 로그 확인"
echo ""
echo "자세한 내용은 SETUP_NGINX.md 파일을 참고하세요"
echo ""
