import dbManager from '../services/database/index.js';
import { createTables } from '../services/auth/schema.js';

async function resetDatabase() {
    console.log('데이터베이스 초기화를 시작합니다...');
    
    try {
        await dbManager.initialize();
        
        // 트랜잭션 시작
        await dbManager.query('BEGIN');
        
        try {
            console.log('기존 테이블을 삭제합니다...');
            
            // 의존성 순서를 고려하여 테이블 삭제
            await dbManager.query(`
                -- 먼저 외래 키를 가진 테이블들을 삭제
                DROP TABLE IF EXISTS activity_logs CASCADE;
                DROP TABLE IF EXISTS user_ip_logs CASCADE;
                DROP TABLE IF EXISTS api_keys CASCADE;
                DROP TABLE IF EXISTS role_permissions CASCADE;
                
                -- 그 다음 참조되는 테이블들을 삭제
                DROP TABLE IF EXISTS permissions CASCADE;
                DROP TABLE IF EXISTS users CASCADE;
                
                -- 마지막으로 독립적인 테이블 삭제
                DROP TABLE IF EXISTS schema_migrations CASCADE;
                DROP TABLE IF EXISTS chat_documents CASCADE;
            `);

            console.log('테이블을 재생성합니다...');
            await createTables(dbManager);
            
            // 트랜잭션 커밋
            await dbManager.query('COMMIT');
            console.log('데이터베이스가 성공적으로 초기화되었습니다.');
        } catch (error) {
            // 오류 발생 시 롤백
            await dbManager.query('ROLLBACK');
            throw error;
        }
    } catch (error) {
        console.error('데이터베이스 초기화 중 오류가 발생했습니다:', error);
        process.exit(1);
    } finally {
        // 연결 풀 종료
        try {
            await dbManager.end();
        } catch (error) {
            console.error('데이터베이스 연결 종료 중 오류:', error);
        }
        process.exit(0);
    }
}

resetDatabase(); 