/**
 * CRAG Constants
 *
 * Corrective RAG 시스템에서 사용하는 상수들
 *
 * @module services/agent-system/crag/constants
 */

export const GRADE_ACTION = {
  PROCEED: 'PROCEED',      // 관련 문서 충분 - 진행
  REWRITE: 'REWRITE',      // 쿼리 재작성 필요
  FALLBACK: 'FALLBACK'      // 웹 검색으로 폴백
};

export const DOCUMENT_GRADE = {
  CORRECT: 'CORRECT',      // 관련 문서
  AMBIGUOUS: 'AMBIGUOUS',  // 모호한 문서
  INCORRECT: 'INCORRECT'   // 관련 없는 문서
};

export const CRAG_STATUS = {
  SUCCESS: 'SUCCESS',
  RETRY: 'RETRY',
  FALLBACK: 'FALLBACK',
  FAILED: 'FAILED'
};