/**
 * @swagger
 * tags:
 *   - name: Web
 *     description: 웹 검색 관련 API (Google, Naver, Daum 검색 엔진의 결과를 병렬로 수집하여 제공)
 */

/**
 * @swagger
 * components:
 *   schemas:
 *     WebSearchRequest:
 *       type: object
 *       required:
 *         - query
 *       properties:
 *         query:
 *           type: string
 *           description: 검색할 텍스트
 *         maxResults:
 *           type: integer
 *           description: 최대 검색 결과 수 (각 검색 엔진의 결과를 종합하여 제공)
 *           minimum: 1
 *           maximum: 10
 *           default: 5
 *     WebSearchResponse:
 *       type: object
 *       properties:
 *         success:
 *           type: boolean
 *         data:
 *           type: array
 *           items:
 *             type: object
 *             properties:
 *               title:
 *                 type: string
 *                 description: 검색 결과 제목
 *               url:
 *                 type: string
 *                 description: 검색 결과 URL
 *               snippet:
 *                 type: string
 *                 description: 검색 결과 요약
 *               source:
 *                 type: string
 *                 description: 검색 엔진 (google, naver, daum 중 하나)
 *                 enum: [google, naver, daum]
 */

/**
 * @swagger
 * /api/v1/web/search/sync:
 *   post:
 *     summary: 웹 검색 요청 (동기식)
 *     description: |
 *       웹에서 정보를 검색하고 결과를 즉시 동기적으로 반환합니다.
 *       Google, Naver, Daum 검색 엔진의 결과를 병렬로 수집하여 제공합니다.
 *       큐 시스템을 거치지 않고 직접 처리됩니다.
 *     tags: [Web]
 *     security:
 *       - apiKeyAuth: []
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           schema:
 *             $ref: '#/components/schemas/WebSearchRequest'
 *           example:
 *             query: "AI에이전트"
 *             maxResults: 5
 *     responses:
 *       200:
 *         description: 성공적인 응답
 *         content:
 *           application/json:
 *             schema:
 *               type: object
 *               properties:
 *                 success:
 *                   type: boolean
 *                 data:
 *                   type: array
 *                   items:
 *                     $ref: '#/components/schemas/WebSearchResult'
 *             example:
 *               success: true
 *               data: [
 *                 {
 *                   title: "최신 AI 에이전트 기술 동향",
 *                   snippet: "AI 에이전트는 인공지능 기술을 활용하여 사용자를 대신해 작업을 수행하는 소프트웨어입니다...",
 *                   url: "https://example.com/ai-agents",
 *                   source: "google"
 *                 },
 *                 {
 *                   title: "AI 에이전트 시스템 구축 가이드",
 *                   snippet: "네이버에서 제공하는 AI 에이전트 시스템 구축 방법에 대한 상세 가이드입니다...",
 *                   url: "https://example.com/ai-agent-guide",
 *                   source: "naver"
 *                 }
 *               ]
 *       401:
 *         description: 인증 실패
 *         content:
 *           application/json:
 *             schema:
 *               $ref: '#/components/schemas/Error'
 *       400:
 *         description: 잘못된 요청
 *         content:
 *           application/json:
 *             schema:
 *               $ref: '#/components/schemas/Error'
 *       500:
 *         description: 서버 내부 오류
 *         content:
 *           application/json:
 *             schema:
 *               $ref: '#/components/schemas/Error'
 */

// /**
//  * @swagger
//  * /api/v1/web/search:
//  *   post:
//  *     summary: 웹 검색 요청 (비동기식)
//  *     description: |
//  *       웹에서 정보를 검색하고 비동기적으로 처리합니다.
//  *       Google, Naver, Daum 검색 엔진의 결과를 병렬로 수집하여 제공합니다.
//  *       큐 시스템을 통해 처리되며 jobId를 통해 상태를 추적할 수 있습니다.
//  *     tags: [Web]
//  *     security:
//  *       - apiKeyAuth: []
//  *     requestBody:
//  *       required: true
//  *       content:
//  *         application/json:
//  *           schema:
//  *             $ref: '#/components/schemas/WebSearchRequest'
//  *           example:
//  *             query: "AI에이전트"
//  *             maxResults: 5
//  *     responses:
//  *       200:
//  *         description: 요청이 큐에 성공적으로 등록됨
//  *         content:
//  *           application/json:
//  *             schema:
//  *               type: object
//  *               properties:
//  *                 success:
//  *                   type: boolean
//  *                 jobId:
//  *                   type: string
//  *                   description: 작업 추적을 위한 고유 식별자
//  *                 status:
//  *                   type: string
//  *                   enum: [queued]
//  *                   description: 작업의 현재 상태
//  *             example:
//  *               success: true
//  *               jobId: "job_123456789"
//  *               status: "queued"
//  *       401:
//  *         description: 인증 실패
//  *         content:
//  *           application/json:
//  *             schema:
//  *               $ref: '#/components/schemas/Error'
//  *       400:
//  *         description: 잘못된 요청
//  *         content:
//  *           application/json:
//  *             schema:
//  *               $ref: '#/components/schemas/Error'
//  */

export const webSchemas = {
    WebSearchRequest: {
        type: 'object',
        required: ['query'],
        properties: {
            query: {
                type: 'string',
                description: '검색할 텍스트'
            },
            maxResults: {
                type: 'integer',
                description: '최대 검색 결과 수 (각 검색 엔진의 결과를 종합하여 제공)',
                minimum: 1,
                maximum: 10,
                default: 5
            }
        }
    },
    WebSearchResult: {
        type: 'object',
        properties: {
            title: {
                type: 'string',
                description: '검색 결과 제목'
            },
            url: {
                type: 'string',
                description: '검색 결과 URL'
            },
            snippet: {
                type: 'string',
                description: '검색 결과 요약'
            },
            source: {
                type: 'string',
                description: '검색 엔진 (google, naver, daum 중 하나)',
                enum: ['google', 'naver', 'daum']
            }
        }
    }
}; 