# AI Tool System - CLI 사용법

AI.RUN의 확장 가능한 도구 시스템을 명령줄에서 관리하는 방법을 설명합니다.

## 🚀 **통합된 CLI 사용법**

기존 `index.js`의 CLI 구조를 유지하면서 도구 관리 기능이 서브커맨드로 통합되었습니다.

### **기본 사용법**

```bash
# 기존 방식 그대로 사용 가능
node index.js "질문이나 작업 내용"
node index.js --chat "채팅 모드로 질문"
node index.js --code "코드 생성 모드"

# 도구 관리는 서브커맨드로 사용
node index.js tools <command> [options]
```

## 📋 **도구 관리 명령어**

### **1. 도구 목록 조회**
```bash
node index.js tools list
```
- 등록된 모든 도구를 카테고리별로 표시
- 각 도구의 활성화 상태와 버전 정보 포함

### **2. 도구 상세 정보 조회**
```bash
node index.js tools info <도구이름>

# 예시
node index.js tools info search_web
node index.js tools info ai_pro
```
- 도구의 매개변수, 설명, 사용법 등 상세 정보 표시

### **3. 도구 테스트**
```bash
node index.js tools test <도구이름> [--args <JSON>]

# 예시
node index.js tools test search_web --args '{"query":"AI 뉴스"}'
node index.js tools test calculator --args '{"expression":"2+2"}'
```
- 도구를 안전하게 테스트 실행
- JSON 형식으로 테스트 매개변수 전달

### **4. 새 도구 템플릿 생성**
```bash
node index.js tools create <도구이름>

# 예시
node index.js tools create my_custom_tool
```
- 새로운 도구 개발을 위한 템플릿 파일 생성
- `tools/custom-tools/` 디렉토리에 파일 생성

### **5. 도구 다시 로드**
```bash
node index.js tools reload
```
- 모든 도구를 다시 로드 (새로 추가된 도구 반영)
- 도구 파일을 수정한 후 실행

### **6. 도구 통계 조회**
```bash
node index.js tools stats
```
- 도구 시스템 전체 통계 정보
- 카테고리별 분포, 실행 통계 등

## 🛠️ **도구 개발 워크플로우**

### **1단계: 템플릿 생성**
```bash
node index.js tools create weather_checker
```

### **2단계: 도구 편집**
생성된 `tools/custom-tools/weather_checker-tool.js` 파일을 편집:

```javascript
const weatherCheckerTool = {
    name: 'weather_checker',
    category: 'utility',
    description: '지역별 날씨 정보를 조회합니다.',
    version: '1.0.0',
    parameters: {
        location: {
            type: 'string',
            required: true,
            description: '조회할 지역명'
        }
    },
    handler: async (args, context) => {
        const { location } = args;
        
        // 날씨 API 호출 로직 구현
        const weatherData = await getWeatherData(location);
        
        return {
            success: true,
            data: weatherData,
            message: `${location}의 날씨 정보를 성공적으로 조회했습니다.`
        };
    }
};

export default weatherCheckerTool;
```

### **3단계: 도구 로드**
```bash
node index.js tools reload
```

### **4단계: 도구 테스트**
```bash
node index.js tools test weather_checker --args '{"location":"서울"}'
```

### **5단계: 도구 정보 확인**
```bash
node index.js tools info weather_checker
```

## 📁 **도구 파일 위치**

### **기본 도구**
- `tools/builtin-tools.js` - 시스템 내장 도구들

### **예제 도구**
- `tools/custom-tools/example-tools.js` - 참고용 예제 도구들

### **사용자 도구**
- `tools/custom-tools/` - 새로 생성한 도구들
- `user-tools/` - 사용자 전용 도구 디렉토리

## 🔧 **고급 사용법**

### **도구 파일 직접 로드**
```javascript
// 도구 레지스트리에 직접 등록
import toolRegistry from './tools/tools-registry.js';

const myTool = {
    name: 'my_tool',
    // ... 도구 정의
};

toolRegistry.registerTool(myTool);
```

### **런타임 도구 관리**
```javascript
// 도구 활성화/비활성화
toolRegistry.enableTool('tool_name');
toolRegistry.disableTool('tool_name');

// 도구 실행
const result = await toolRegistry.executeTool('tool_name', args, userId);
```

## 🎯 **실제 사용 예시**

### **1. AI 채팅에서 도구 사용**
```bash
# 웹 검색이 활성화된 채팅
node index.js --chat --web "최신 AI 뉴스 알려줘"

# 문서 검색이 활성화된 채팅  
node index.js --chat --rag "프로젝트 문서에서 API 사용법 찾아줘"

# AI프로 모드 (AI프로)
node index.js --chat --smart-research "블록체인 기술의 최신 동향"
```

### **2. 도구 개발 및 테스트**
```bash
# 새 도구 생성
node index.js tools create data_analyzer

# 도구 편집 후 로드
node index.js tools reload

# 도구 테스트
node index.js tools test data_analyzer --args '{"data":[1,2,3,4,5]}'

# 도구 정보 확인
node index.js tools info data_analyzer
```

### **3. 시스템 관리**
```bash
# 모든 도구 목록 확인
node index.js tools list

# 시스템 통계 확인
node index.js tools stats

# 특정 도구 상세 정보
node index.js tools info ai_pro
```

## 🚨 **주의사항**

1. **기존 호환성**: 기존 `index.js` 사용법은 모두 그대로 유지됩니다.
2. **도구 네이밍**: 도구 이름은 영문자, 숫자, 언더스코어만 사용하세요.
3. **파일 위치**: 새 도구는 `tools/custom-tools/` 디렉토리에 생성됩니다.
4. **재로드 필수**: 도구 파일을 수정한 후에는 반드시 `reload` 명령을 실행하세요.

## 📚 **추가 리소스**

- [도구 개발 가이드](./DEVELOPMENT_GUIDE.md)
- [시스템 통합 가이드](./INTEGRATION_GUIDE.md)
- [예제 도구 모음](./custom-tools/example-tools.js)
- [빠른 시작 스크립트](./quick-start.sh) 