# 폼 빌더 여러 페이지 문서 테스트 계획

## 테스트 목적
여러 페이지 PDF 문서가 AI 폼 빌더에서 어떻게 처리되는지 검증

## 현재 시스템 동작

### 처리 흐름
1. **업로드**: 전체 PDF 파일 업로드
2. **미리보기**: 최대 5페이지까지 이미지로 표시
3. **분석**: Chandra가 전체 문서를 HTML/Markdown으로 변환
4. **폼 생성**: AI가 변환된 전체 내용을 분석하여 폼 필드 생성

### 코드 분석 결과
- `chandra/process/route.ts`: 전체 파일 처리 (페이지 선택 없음)
- `generate-fields/route.ts`: 전체 변환 결과 사용
- `page.tsx`: 최대 5페이지 미리보기 (실제로는 모든 페이지 처리됨)

## 테스트 케이스

### 케이스 1: 단일 페이지 폼
- **문서**: 1페이지 신청서
- **예상 결과**: 모든 필드 정상 인식
- **확인 사항**: 필드 순서, 그룹 구조, 필수 항목

### 케이스 2: 다중 페이지 폼 (페이지별 독립)
- **문서**: 각 페이지에 독립적인 섹션 (예: 1페이지-개인정보, 2페이지-사업계획)
- **예상 결과**: 모든 페이지의 필드가 순서대로 포함
- **확인 사항**:
  - 페이지 경계를 넘는 필드 인식
  - 그룹 구조 유지
  - 페이지 순서대로 필드 생성

### 케이스 3: 다중 페이지 폼 (페이지 걸침)
- **문서**: 표가 2페이지에 걸쳐 있는 경우
- **예상 결과**: 표 전체가 하나의 그룹으로 인식
- **확인 사항**:
  - 페이지 경계에서 끊긴 표 인식
  - 표 헤더와 데이터 행 매칭
  - 필드 누락 여부

### 케이스 4: 긴 문서 (5페이지 이상)
- **문서**: 5페이지 이상의 신청서
- **예상 결과**: 모든 페이지 처리되지만 미리보기는 5페이지만
- **확인 사항**:
  - 6페이지 이상의 필드도 인식되는지
  - 미리보기 제한 안내 표시
  - 전체 페이지 처리 성공

## 발견된 문제점

### 1. 미리보기 vs 실제 처리 불일치
- **문제**: 미리보기는 5페이지, 실제로는 모든 페이지 처리
- **사용자 혼란**: "미리보기에 없는 페이지도 처리되나요?"

### 2. 페이지 선택 불가
- **문제**: 특정 페이지만 처리할 수 없음
- **시나리오**: "10페이지 문서 중 3-5페이지만 폼으로 만들고 싶어요"

### 3. 미리보기 네비게이션 부족
- **문제**: 전체 페이지 확인 불가
- **불편**: 스크롤로만 확인, 페이지 점프 없음

## 개선 제안

### 제안 1: 페이지 선택 기능 추가
```
[ ] 전체 페이지 처리
[ ] 특정 페이지만 처리
    페이지 범위: [  1  ] ~ [  5  ]
```

### 제안 2: 미리보기 페이지 네비게이션
```
< 1 2 3 4 5 ... 10 >
현재 페이지: 3/10
```

### 제안 3: 진행 상황 표시 개선
```
페이지 1/10 분석 중... 10%
페이지 2/10 분석 중... 20%
...
```

### 제안 4: 미리보기와 처리 범위 일치
- 미리보기 제한 해제 (가상 스크롤)
- 또는 "미리보기: 5페이지 / 실제 처리: 전체" 명확히 표시

## 테스트 실행 방법

1. 다양한 페이지 수의 PDF 준비
2. 각 케이스별로 업로드 및 분석
3. 생성된 폼 필드 확인
4. 누락되거나 잘못 인식된 필드 기록
5. Chandra 변환 결과 확인 (HTML/Markdown)

## 예상 개발 범위

### 단기 (즉시 가능)
- 미리보기 안내 메시지 추가
- 전체 페이지 수 표시
- 페이지 네비게이션 버튼

### 중기 (구조 변경 필요)
- 페이지 범위 선택 기능
- 페이지별 미리보기 토글
- Chandra API에 페이지 범위 파라미터 추가

### 장기 (대규모 개선)
- 가상 스크롤링으로 모든 페이지 미리보기
- 실시간 페이지 선택 UI
- 페이지별 처리 진행률 표시
