This is a [Next.js](https://nextjs.org) project bootstrapped with [`create-next-app`](https://nextjs.org/docs/app/api-reference/cli/create-next-app).

## Environment Variables (Optional)

By default, the app automatically uses the same protocol (HTTP/HTTPS) as your website. 

If you need custom API server URLs, create a `.env.local` file:

```bash
# Only needed if API server is on different domain
NEXT_PUBLIC_API_SERVER_URL=https://your-api-domain.com/api/v1

# Only needed if WebSocket server is on different domain  
NEXT_PUBLIC_WS_SERVER_URL=wss://your-api-domain.com

# Only needed if Report server is on different domain
REPORT_API_SERVER=https://your-api-domain.com/report
```

## LLM Provider Configuration

To use different LLM providers, configure the appropriate environment variables:

### OpenAI (Default)
```bash
OPENAI_API_KEY=your_openai_api_key
```

### Anthropic
```bash
ANTHROPIC_API_KEY=your_anthropic_api_key
```

### Ollama (Local)
```bash
# Optional: Custom Ollama endpoint (default: http://localhost:11434/v1)
OLLAMA_BASE_URL=http://localhost:11434/v1
```

Make sure Ollama is running locally:
```bash
# Install Ollama first from https://ollama.com/
ollama serve

# Pull a model (example)
ollama pull llama2
ollama pull deepseek-r1
```

### Groq
```bash
GROQ_API_KEY=your_groq_api_key
```

### DeepSeek
```bash
DEEPSEEK_API_KEY=your_deepseek_api_key
```

### Google Gemini
```bash
GEMINI_API_KEY=your_gemini_api_key
# Optional: Custom endpoint
GEMINI_BASE_URL=https://generativelanguage.googleapis.com/v1beta/openai/
```

### Custom Providers
For other OpenAI-compatible providers, use:
```bash
YOUR_PROVIDER_API_KEY=your_api_key
YOUR_PROVIDER_BASE_URL=https://your-provider-url.com/v1
```

## MCP (Model Context Protocol) with Ollama

This application supports MCP servers that can work with local Ollama models. To use MCP with Ollama:

1. **Install Ollama**: Download from [https://ollama.com/](https://ollama.com/)

2. **Start Ollama**:
   ```bash
   ollama serve
   ```

3. **Pull models**:
   ```bash
   ollama pull llama2
   ollama pull deepseek-r1
   ```

4. **Configure MCP servers** in `mcp_config.json`:
   ```json
   {
     "mcpServers": {
       "time": {
         "command": "uvx",
         "args": ["mcp-server-time", "--local-timezone=Asia/Seoul"]
       },
       "filesystem": {
         "command": "uvx",
         "args": ["mcp-server-filesystem", "/path/to/allowed/directory"]
       }
     }
   }
   ```

5. **Use Ollama provider** in the chat interface to leverage local models with MCP tools.

## Production Deployment with Nginx

When deploying behind nginx proxy, make sure your nginx configuration includes:

```nginx
server {
    listen 443 ssl;
    server_name your-domain.com;
    
    # SSL configuration
    ssl_certificate /path/to/your/certificate.crt;
    ssl_certificate_key /path/to/your/private.key;
    
    # Frontend (Next.js)
    location / {
        proxy_pass http://localhost:5700;
        proxy_http_version 1.1;
        proxy_set_header Upgrade $http_upgrade;
        proxy_set_header Connection 'upgrade';
        proxy_set_header Host $host;
        proxy_set_header X-Real-IP $remote_addr;
        proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for;
        proxy_set_header X-Forwarded-Proto $scheme;
        proxy_cache_bypass $http_upgrade;
    }
    
    # Backend API
    location /api/ {
        proxy_pass http://localhost:5500;
        proxy_http_version 1.1;
        proxy_set_header Upgrade $http_upgrade;
        proxy_set_header Connection 'upgrade';
        proxy_set_header Host $host;
        proxy_set_header X-Real-IP $remote_addr;
        proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for;
        proxy_set_header X-Forwarded-Proto $scheme;
        proxy_cache_bypass $http_upgrade;
    }
    
    # Report Server (문서 생성 서버)
    location /report/ {
        proxy_pass http://localhost:5620/;
        proxy_http_version 1.1;
        proxy_set_header Upgrade $http_upgrade;
        proxy_set_header Connection 'upgrade';
        proxy_set_header Host $host;
        proxy_set_header X-Real-IP $remote_addr;
        proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for;
        proxy_set_header X-Forwarded-Proto $scheme;
        proxy_cache_bypass $http_upgrade;
        
        # SSE 스트리밍을 위한 추가 설정
        proxy_buffering off;
        proxy_cache off;
        proxy_read_timeout 86400;
    }
}
```

Then set your environment variables:
```bash
NEXT_PUBLIC_API_SERVER_URL=https://your-domain.com/api/v1
NEXT_PUBLIC_WS_SERVER_URL=wss://your-domain.com
REPORT_API_SERVER=https://your-domain.com/report
```

## Getting Started

First, run the development server:

```bash
npm run dev
# or
yarn dev
# or
pnpm dev
# or
bun dev
```

Open [http://localhost:3000](http://localhost:3000) with your browser to see the result.

You can start editing the page by modifying `app/page.tsx`. The page auto-updates as you edit the file.

This project uses [`next/font`](https://nextjs.org/docs/app/building-your-application/optimizing/fonts) to automatically optimize and load [Geist](https://vercel.com/font), a new font family for Vercel.

## Learn More

To learn more about Next.js, take a look at the following resources:

- [Next.js Documentation](https://nextjs.org/docs) - learn about Next.js features and API.
- [Learn Next.js](https://nextjs.org/learn) - an interactive Next.js tutorial.

You can check out [the Next.js GitHub repository](https://github.com/vercel/next.js) - your feedback and contributions are welcome!

## Deploy on Vercel

The easiest way to deploy your Next.js app is to use the [Vercel Platform](https://vercel.com/new?utm_medium=default-template&filter=next.js&utm_source=create-next-app&utm_campaign=create-next-app-readme) from the creators of Next.js.

Check out our [Next.js deployment documentation](https://nextjs.org/docs/app/building-your-application/deploying) for more details.
