import requests
import json
import time
import os

OLLAMA_URL = "https://profound-balanced-mammoth.ngrok-free.app/api/generate"
OPENAI_API_KEY = "sk-svcacct-_EeP3zLIZEJdz5E4Sgcs4gM0ysn27VAg7F9EBlUaahx1rJ8fFQVYXj7Ej6Eyun17bAT3BlbkFJYABDHmKqRMCYqOFlEfmiNue2dm3L9nIUNv7l-Vfze1nNtCyxI9sAjD-IdZgj8kE9cA"
OPENAI_MODEL = "gpt-4.1-nano"  

MODELS = [
    "hamonize:latest",
    "devstral:latest",
    "gemma3:12b",
    "hyperclova-1.5b:latest",
    "mistral-small3.1:latest",
    "qwen3:14b",
]
QUESTIONS = [
    {"category": "math", "question": "2+2는?", "answer": "4"},
    {"category": "writing", "question": "다음 문장을 영어로 번역: 나는 집에 간다.", "answer": "I go home."},
    {"category": "coding", "question": "다음 코드의 출력은? print(1+1)", "answer": "2"},
    {"category": "reasoning", "question": '"고양이"와 "개"의 공통점은?', "answer": "동물"},
    {"category": "grammar", "question": '"나는 학교에 갑니다." 문법이 올바른가?', "answer": "예"},
]

SAVE_PATH = "ollama_eval_judge_results.json"

# 기존 결과 불러오기
if os.path.exists(SAVE_PATH):
    with open(SAVE_PATH, "r", encoding="utf-8") as f:
        results = json.load(f)
else:
    results = {}

def judge_score(judge_prompt, model_answer, gold_answer):
    prompt = f"""
다음은 기준 답변(정답)과 AI 모델의 답변입니다.

[질문]
{judge_prompt}

[기준 답변]
{gold_answer}

[모델 답변]
{model_answer}

모델 답변이 기준 답변과 의미적으로 얼마나 유사하고 적절한지 1~10점으로 평가해 주세요.
- 10점: 완벽하게 일치하거나, 의미/논리/문법 모두 매우 우수
- 7~9점: 거의 일치, 약간의 표현 차이만 있음
- 4~6점: 부분적으로 맞으나, 일부 오류/부족/부정확함
- 1~3점: 거의 맞지 않음, 핵심 정보 누락/오류
- 0점: 완전히 틀림, 무관한 답변

점수만 숫자로 답변하세요.
"""
    headers = {
        "Authorization": f"Bearer {OPENAI_API_KEY}",
        "Content-Type": "application/json"
    }
    data = {
        "model": OPENAI_MODEL,
        "messages": [
            {"role": "system", "content": "당신은 AI 답변 평가자입니다. 반드시 점수만 숫자로 출력하세요."},
            {"role": "user", "content": prompt}
        ],
        "max_tokens": 10,
        "temperature": 0
    }
    try:
        resp = requests.post("https://api.openai.com/v1/chat/completions", headers=headers, json=data, timeout=60)
        if resp.status_code == 200:
            score_str = resp.json()["choices"][0]["message"]["content"].strip()
            try:
                score = int(score_str)
                if 0 <= score <= 10:
                    return score
            except:
                pass
            print("Judge LLM 점수 파싱 실패:", score_str)
            return 0
        else:
            print("Judge LLM API 오류:", resp.status_code, resp.text)
            return 0
    except Exception as e:
        print("Judge LLM 예외:", e)
        return 0

for model in MODELS:
    if model not in results:
        results[model] = {}
    for q in QUESTIONS:
        if q["category"] in results[model]:
            continue  # 이미 평가된 항목은 건너뜀
        payload = {
            "model": model,
            "prompt": q["question"],
            "stream": False
        }
        try:
            resp = requests.post(OLLAMA_URL, json=payload, timeout=60)
            if resp.status_code == 200:
                data = resp.json()
                answer = data.get("response", "").strip()
                score = judge_score(q["question"], answer, q["answer"])
                results[model][q["category"]] = {
                    "question": q["question"],
                    "model_answer": answer,
                    "score": score
                }
                print(f"[{model}][{q['category']}] 답변: {answer} (Judge 점수: {score})")
            else:
                print(f"[{model}][{q['category']}] 오류: {resp.status_code} {resp.text}")
                results[model][q["category"]] = {
                    "question": q["question"],
                    "model_answer": "",
                    "score": 0,
                    "error": resp.text
                }
        except Exception as e:
            print(f"[{model}][{q['category']}] 예외: {e}")
            results[model][q["category"]] = {
                "question": q["question"],
                "model_answer": "",
                "score": 0,
                "error": str(e)
            }
        time.sleep(1)
        with open(SAVE_PATH, "w", encoding="utf-8") as f:
            json.dump(results, f, ensure_ascii=False, indent=2)

print("\n전체 Judge 평가 결과가 ollama_eval_judge_results.json 파일에 저장되었습니다.")
