import { NextResponse } from 'next/server';
import fs from 'fs';
import path from 'path';

export async function GET() {
  try {
    const dataPath = path.join(process.cwd(), '../../data/industry-classification.json');
    const jsonData = fs.readFileSync(dataPath, 'utf-8');
    const data = JSON.parse(jsonData);

    return NextResponse.json({
      success: true,
      data: {
        classifications: data.classifications
      }
    });
  } catch (error) {
    console.error('산업분류 데이터 로드 오류:', error);

    return NextResponse.json({
      success: false,
      error: error instanceof Error ? error.message : '산업분류 데이터 로드에 실패했습니다.'
    }, { status: 500 });
  }
}
