const { Pool } = require('pg');
const fs = require('fs');
const path = require('path');

// Database configuration
const pool = new Pool({
  host: process.env.DB_HOST || process.env.POSTGRES_HOST || 'localhost',
  port: parseInt(process.env.DB_PORT || process.env.POSTGRES_PORT || '5433'),
  user: process.env.DB_USER || process.env.POSTGRES_USER || 'ivs',
  password: process.env.DB_PASSWORD || process.env.POSTGRES_PASSWORD || "Exitem08**",
  database: process.env.DB_NAME || process.env.POSTGRES_DB || 'airun',
});

async function runMigration() {
  const client = await pool.connect();
  try {
    console.log('🔄 Running formbuilder CASCADE constraints migration...');

    // Read migration SQL file
    const migrationPath = path.join(__dirname, 'formbuilder-cascade-constraints.sql');
    const migrationSQL = fs.readFileSync(migrationPath, 'utf8');

    // Execute migration
    await client.query(migrationSQL);

    console.log('✅ Migration completed successfully');

    // Verify constraints
    const result = await client.query(`
      SELECT
        tc.table_name,
        tc.constraint_name,
        tc.constraint_type,
        kcu.column_name,
        ccu.table_name AS foreign_table_name,
        rc.delete_rule
      FROM information_schema.table_constraints AS tc
      JOIN information_schema.key_column_usage AS kcu
        ON tc.constraint_name = kcu.constraint_name
        AND tc.table_schema = kcu.table_schema
      JOIN information_schema.constraint_column_usage AS ccu
        ON ccu.constraint_name = tc.constraint_name
        AND ccu.table_schema = tc.table_schema
      LEFT JOIN information_schema.referential_constraints AS rc
        ON tc.constraint_name = rc.constraint_name
      WHERE tc.constraint_type = 'FOREIGN KEY'
        AND tc.table_name IN ('ai_form_responses', 'ai_form_response_attachments')
      ORDER BY tc.table_name, tc.constraint_name;
    `);

    console.log('\n📋 Current CASCADE constraints:');
    result.rows.forEach(row => {
      console.log(`  - ${row.table_name}.${row.column_name} -> ${row.foreign_table_name}`);
      console.log(`    DELETE RULE: ${row.delete_rule}`);
    });

  } catch (error) {
    console.error('❌ Migration failed:', error);
    throw error;
  } finally {
    client.release();
    await pool.end();
  }
}

// Run migration
runMigration()
  .then(() => {
    console.log('\n✅ All done!');
    process.exit(0);
  })
  .catch((error) => {
    console.error('\n❌ Error:', error);
    process.exit(1);
  });
