// PostgreSQL 연결 정보 (중앙 설정에서 가져오기)
import { clearDatabaseConfigCache, getDatabaseConfigAsync } from '@/config/serverConfig';

interface DbPoolConfig {
  host: string;
  port: number;
  user: string;
  password: string;
  database: string;
  ssl: boolean;
  max: number;
  idleTimeoutMillis: number;
  connectionTimeoutMillis: number;
}

let cachedDbConfig: DbPoolConfig | null = null;

async function buildDbConfig(): Promise<DbPoolConfig> {
  const config = await getDatabaseConfigAsync();
  return {
    host: config.host,
    port: config.port,
    user: config.user,
    password: config.password,
    database: config.name,
    ssl: false,
    max: 20,
    idleTimeoutMillis: 30000,
    connectionTimeoutMillis: 2000,
  };
}

export async function getDbPoolConfig(): Promise<DbPoolConfig> {
  if (!cachedDbConfig) {
    cachedDbConfig = await buildDbConfig();
  }
  return cachedDbConfig;
}

export async function refreshDbPoolConfig(): Promise<DbPoolConfig> {
  clearDatabaseConfigCache();
  cachedDbConfig = null;
  return getDbPoolConfig();
}
