import { NextRequest, NextResponse } from 'next/server';

const ULTRATHINK_API_BASE = 'http://121.78.116.30:8502';

// POST: 문서 처리 요청을 Ultrathink API로 프록시
export async function POST(request: NextRequest) {
  try {
    const formData = await request.formData();

    // Ultrathink API로 요청 전달
    const response = await fetch(`${ULTRATHINK_API_BASE}/process`, {
      method: 'POST',
      body: formData,
    });

    const data = await response.json();

    return NextResponse.json(data, { status: response.status });
  } catch (error) {
    console.error('Ultrathink process error:', error);
    return NextResponse.json(
      { success: false, error: 'Failed to process document' },
      { status: 500 }
    );
  }
}
