import { NextRequest, NextResponse } from 'next/server';
import { withAnyAuth } from '../../middlewares';
import { getApiServerUrl } from '@/config/serverConfig';

const API_SERVER = getApiServerUrl();

// POST: AI 견적서 생성
export async function POST(request: NextRequest) {
  return withAnyAuth(request, async (req, userData, authType) => {
    try {
      const body = await req.json();

      // username 추가
      if (userData.username) {
        body.username = userData.username;
      }

      const apiUrl = `${API_SERVER}/quotations/generate`;

      const headers: Record<string, string> = {
        'Content-Type': 'application/json',
      };

      const apiKey = req.headers.get('x-api-key');
      if (apiKey) {
        headers['X-API-Key'] = apiKey;
      }

      const response = await fetch(apiUrl, {
        method: 'POST',
        headers,
        body: JSON.stringify(body)
      });

      if (!response.ok) {
        const errorText = await response.text();
        console.error('AI 견적서 생성 실패:', response.status, errorText);
        return NextResponse.json(
          { success: false, error: { message: 'AI 견적서 생성에 실패했습니다.' } },
          { status: response.status }
        );
      }

      const data = await response.json();
      return NextResponse.json(data);
    } catch (error) {
      console.error('AI 견적서 생성 오류:', error);
      return NextResponse.json(
        { success: false, error: { message: 'AI 견적서 생성 중 오류가 발생했습니다.' } },
        { status: 500 }
      );
    }
  });
}
