// Promise.withResolvers polyfill 먼저 로드
import '@/lib/promise-polyfill';

import './globals.css';
import type { Metadata } from 'next';
import { Inter } from 'next/font/google';
import { initSupportTicketsTable } from '@/app/api/db';
import ThemeProvider from '@/components/ThemeProvider';
import { LanguageProvider } from '@/contexts/LanguageContext';
import ConditionalLayout from '@/components/ConditionalLayout';

// Initialize the database table on server start
initSupportTicketsTable();

const inter = Inter({ subsets: ['latin'] });

export const metadata: Metadata = {
  title: 'Build Your Sovereign AI',
  description: 'Build Your Sovereign AI - Private & Secure',
};

export default function RootLayout({
  children,
}: Readonly<{
  children: React.ReactNode;
}>) {
  return (
    <html lang="ko" suppressHydrationWarning>
      <body className={inter.className} suppressHydrationWarning>
        <ThemeProvider>
          <LanguageProvider>
            <ConditionalLayout>
              {children}
            </ConditionalLayout>
          </LanguageProvider>
        </ThemeProvider>
      </body>
    </html>
  );
}
